		#INCLUDE "C:\PROGRA~1\FED\WIZPIC\P16F877.INC"
		LIST
; P16F877.INC  STANDARD HEADER FILE, VERSION 1.00    MICROCHIP TECHNOLOGY, INC.
		NOLIST
; THIS HEADER FILE DEFINES CONFIGURATIONS, REGISTERS, AND OTHER USEFUL BITS OF
; INFORMATION FOR THE PIC16F877 MICROCONTROLLER.  THESE NAMES ARE TAKEN TO MATCH 
; THE DATA SHEETS AS CLOSELY AS POSSIBLE.  
; NOTE THAT THE PROCESSOR MUST BE SELECTED BEFORE THIS FILE IS 
; INCLUDED.  THE PROCESSOR MAY BE SELECTED THE FOLLOWING WAYS:
;       1. COMMAND LINE SWITCH:
;               C:\ MPASM MYFILE.ASM /PIC16F877
;       2. LIST DIRECTIVE IN THE SOURCE FILE
;               LIST   P=PIC16F877
;       3. PROCESSOR TYPE ENTRY IN THE MPASM FULL-SCREEN INTERFACE
;==========================================================================
;
;       REVISION HISTORY
;
;==========================================================================
;REV:   DATE:    REASON:
;1.00   08/07/98 INITIAL RELEASE
;==========================================================================
;
;       VERIFY PROCESSOR
;
;==========================================================================
;==========================================================================
;
;       REGISTER DEFINITIONS
;
;==========================================================================
W                            EQU     H'0000'
F                            EQU     H'0001'
;----- REGISTER FILES------------------------------------------------------
INDF                         EQU     H'0000'
TMR0                         EQU     H'0001'
PCL                          EQU     H'0002'
STATUS                       EQU     H'0003'
FSR                          EQU     H'0004'
PORTA                        EQU     H'0005'
PORTB                        EQU     H'0006'
PORTC                        EQU     H'0007'
PORTD                        EQU     H'0008'
PORTE                        EQU     H'0009'
PCLATH                       EQU     H'000A'
INTCON                       EQU     H'000B'
PIR1                         EQU     H'000C'
PIR2                         EQU     H'000D'
TMR1L                        EQU     H'000E'
TMR1H                        EQU     H'000F'
T1CON                        EQU     H'0010'
TMR2                         EQU     H'0011'
T2CON                        EQU     H'0012'
SSPBUF                       EQU     H'0013'
SSPCON                       EQU     H'0014'
CCPR1L                       EQU     H'0015'
CCPR1H                       EQU     H'0016'
CCP1CON                      EQU     H'0017'
RCSTA                        EQU     H'0018'
TXREG                        EQU     H'0019'
RCREG                        EQU     H'001A'
CCPR2L                       EQU     H'001B'
CCPR2H                       EQU     H'001C'
CCP2CON                      EQU     H'001D'
ADRESH                       EQU     H'001E'
ADCON0                       EQU     H'001F'
OPTION_REG                   EQU     H'0081'
TRISA                        EQU     H'0085'
TRISB                        EQU     H'0086'
TRISC                        EQU     H'0087'
TRISD                        EQU     H'0088'
TRISE                        EQU     H'0089'
PIE1                         EQU     H'008C'
PIE2                         EQU     H'008D'
PCON                         EQU     H'008E'
SSPCON2                      EQU     H'0091'
PR2                          EQU     H'0092'
SSPADD                       EQU     H'0093'
SSPSTAT                      EQU     H'0094'
TXSTA                        EQU     H'0098'
SPBRG                        EQU     H'0099'
ADRESL                       EQU     H'009E'
ADCON1                       EQU     H'009F'
EEDATA                       EQU     H'010C'
EEADR                        EQU     H'010D'
EEDATH                       EQU     H'010E'
EEADRH                       EQU     H'010F'
EECON1                       EQU     H'018C'
EECON2                       EQU     H'018D'
;----- STATUS BITS --------------------------------------------------------
IRP                          EQU     H'0007'
RP1                          EQU     H'0006'
RP0                          EQU     H'0005'
NOT_TO                       EQU     H'0004'
NOT_PD                       EQU     H'0003'
Z                            EQU     H'0002'
DC                           EQU     H'0001'
C                            EQU     H'0000'
;----- INTCON BITS --------------------------------------------------------
GIE                          EQU     H'0007'
PEIE                         EQU     H'0006'
T0IE                         EQU     H'0005'
INTE                         EQU     H'0004'
RBIE                         EQU     H'0003'
T0IF                         EQU     H'0002'
INTF                         EQU     H'0001'
RBIF                         EQU     H'0000'
;----- PIR1 BITS ----------------------------------------------------------
PSPIF                        EQU     H'0007'
ADIF                         EQU     H'0006'
RCIF                         EQU     H'0005'
TXIF                         EQU     H'0004'
SSPIF                        EQU     H'0003'
CCP1IF                       EQU     H'0002'
TMR2IF                       EQU     H'0001'
TMR1IF                       EQU     H'0000'
;----- PIR2 BITS ----------------------------------------------------------
EEIF                         EQU     H'0004'
BCLIF                        EQU     H'0003'
CCP2IF                       EQU     H'0000'
;----- T1CON BITS ---------------------------------------------------------
T1CKPS1                      EQU     H'0005'
T1CKPS0                      EQU     H'0004'
T1OSCEN                      EQU     H'0003'
NOT_T1SYNC                   EQU     H'0002'
T1INSYNC                     EQU     H'0002'    ; BACKWARD COMPATIBILITY ONLY
TMR1CS                       EQU     H'0001'
TMR1ON                       EQU     H'0000'
;----- T2CON BITS ---------------------------------------------------------
TOUTPS3                      EQU     H'0006'
TOUTPS2                      EQU     H'0005'
TOUTPS1                      EQU     H'0004'
TOUTPS0                      EQU     H'0003'
TMR2ON                       EQU     H'0002'
T2CKPS1                      EQU     H'0001'
T2CKPS0                      EQU     H'0000'
;----- SSPCON BITS --------------------------------------------------------
WCOL                         EQU     H'0007'
SSPOV                        EQU     H'0006'
SSPEN                        EQU     H'0005'
CKP                          EQU     H'0004'
SSPM3                        EQU     H'0003'
SSPM2                        EQU     H'0002'
SSPM1                        EQU     H'0001'
SSPM0                        EQU     H'0000'
;----- CCP1CON BITS -------------------------------------------------------
CCP1X                        EQU     H'0005'
CCP1Y                        EQU     H'0004'
CCP1M3                       EQU     H'0003'
CCP1M2                       EQU     H'0002'
CCP1M1                       EQU     H'0001'
CCP1M0                       EQU     H'0000'
;----- RCSTA BITS ---------------------------------------------------------
SPEN                         EQU     H'0007'
RX9                          EQU     H'0006'
RC9                          EQU     H'0006'    ; BACKWARD COMPATIBILITY ONLY
NOT_RC8                      EQU     H'0006'    ; BACKWARD COMPATIBILITY ONLY
RC8_9                        EQU     H'0006'    ; BACKWARD COMPATIBILITY ONLY
SREN                         EQU     H'0005'
CREN                         EQU     H'0004'
ADDEN                        EQU     H'0003'
FERR                         EQU     H'0002'
OERR                         EQU     H'0001'
RX9D                         EQU     H'0000'
RCD8                         EQU     H'0000'    ; BACKWARD COMPATIBILITY ONLY
;----- CCP2CON BITS -------------------------------------------------------
CCP2X                        EQU     H'0005'
CCP2Y                        EQU     H'0004'
CCP2M3                       EQU     H'0003'
CCP2M2                       EQU     H'0002'
CCP2M1                       EQU     H'0001'
CCP2M0                       EQU     H'0000'
;----- ADCON0 BITS --------------------------------------------------------
ADCS1                        EQU     H'0007'
ADCS0                        EQU     H'0006'
CHS2                         EQU     H'0005'
CHS1                         EQU     H'0004'
CHS0                         EQU     H'0003'
GO                           EQU     H'0002'
NOT_DONE                     EQU     H'0002'
GO_DONE                      EQU     H'0002'
CHS3                         EQU     H'0001'
ADON                         EQU     H'0000'
;----- OPTION BITS --------------------------------------------------------
NOT_RBPU                     EQU     H'0007'
INTEDG                       EQU     H'0006'
T0CS                         EQU     H'0005'
T0SE                         EQU     H'0004'
PSA                          EQU     H'0003'
PS2                          EQU     H'0002'
PS1                          EQU     H'0001'
PS0                          EQU     H'0000'
;----- TRISE BITS ---------------------------------------------------------
IBF                          EQU     H'0007'
OBF                          EQU     H'0006'
IBOV                         EQU     H'0005'
PSPMODE                      EQU     H'0004'
TRISE2                       EQU     H'0002'
TRISE1                       EQU     H'0001'
TRISE0                       EQU     H'0000'
;----- PIE1 BITS ----------------------------------------------------------
PSPIE                        EQU     H'0007'
ADIE                         EQU     H'0006'
RCIE                         EQU     H'0005'
TXIE                         EQU     H'0004'
SSPIE                        EQU     H'0003'
CCP1IE                       EQU     H'0002'
TMR2IE                       EQU     H'0001'
TMR1IE                       EQU     H'0000'
;----- PIE2 BITS ----------------------------------------------------------
EEIE                         EQU     H'0004'
BCLIE                        EQU     H'0003'
CCP2IE                       EQU     H'0000'
;----- PCON BITS ----------------------------------------------------------
NOT_POR                      EQU     H'0001'
NOT_BO                       EQU     H'0000'
NOT_BOR                      EQU     H'0000'
;----- SSPCON2 BITS --------------------------------------------------------
GCEN                         EQU     H'0007'
ACKSTAT                      EQU     H'0006'
ACKDT                        EQU     H'0005'
ACKEN                        EQU     H'0004'
RCEN                         EQU     H'0003'
PEN                          EQU     H'0002'
RSEN                         EQU     H'0001'   
SEN                          EQU     H'0000'   
;----- SSPSTAT BITS -------------------------------------------------------
SMP                          EQU     H'0007'
CKE                          EQU     H'0006'
D                            EQU     H'0005'
I2C_DATA                     EQU     H'0005'
NOT_A                        EQU     H'0005'
NOT_ADDRESS                  EQU     H'0005'
D_A                          EQU     H'0005'
DATA_ADDRESS                 EQU     H'0005'
P                            EQU     H'0004'
I2C_STOP                     EQU     H'0004'
S                            EQU     H'0003'
I2C_START                    EQU     H'0003'
R                            EQU     H'0002'
I2C_READ                     EQU     H'0002'
NOT_W                        EQU     H'0002'
NOT_WRITE                    EQU     H'0002'
R_W                          EQU     H'0002'
READ_WRITE                   EQU     H'0002'
UA                           EQU     H'0001'
BF                           EQU     H'0000'
;----- TXSTA BITS ---------------------------------------------------------
CSRC                         EQU     H'0007'
TX9                          EQU     H'0006'
NOT_TX8                      EQU     H'0006'    ; BACKWARD COMPATIBILITY ONLY
TX8_9                        EQU     H'0006'    ; BACKWARD COMPATIBILITY ONLY
TXEN                         EQU     H'0005'
SYNC                         EQU     H'0004'
BRGH                         EQU     H'0002'
TRMT                         EQU     H'0001'
TX9D                         EQU     H'0000'
TXD8                         EQU     H'0000'    ; BACKWARD COMPATIBILITY ONLY
;----- ADCON1 BITS --------------------------------------------------------
ADFM                         EQU     H'0005'
PCFG3                        EQU     H'0003'
PCFG2                        EQU     H'0002'
PCFG1                        EQU     H'0001'
PCFG0                        EQU     H'0000'
;----- EECON1 BITS --------------------------------------------------------
EEPGD                        EQU     H'0007'
WRERR                        EQU     H'0003'
WREN                         EQU     H'0002'
WR                           EQU     H'0001'
RD                           EQU     H'0000'
;==========================================================================
;
;       RAM DEFINITION
;
;==========================================================================
;__MAXRAM H'1FF'
;__BADRAM H'8F'-H'90', H'95'-H'97', H'9A'-H'9D'
;__BADRAM H'105', H'107'-H'109'
;__BADRAM H'185', H'187'-H'189', H'18E'-H'18F'
;==========================================================================
;
;       CONFIGURATION BITS
;
;==========================================================================
_BODEN_ON                    EQU     H'3FFF'
_BODEN_OFF                   EQU     H'3FBF'
_CP_ALL                      EQU     H'0FCF'
_CP_HALF                     EQU     H'1FDF'
_CP_UPPER_256                EQU     H'2FEF'
_CP_OFF                      EQU     H'3FFF'
_WRT_ENABLE_ON               EQU     H'3FFF'
_WRT_ENABLE_OFF              EQU     H'3DFF'
_PWRTE_OFF                   EQU     H'3FFF'
_PWRTE_ON                    EQU     H'3FF7'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FFB'
_LP_OSC                      EQU     H'3FFC'
_XT_OSC                      EQU     H'3FFD'
_HS_OSC                      EQU     H'3FFE'
_RC_OSC                      EQU     H'3FFF'
_DEBUG_ON                    EQU     H'37FF'
_DEGUB_OFF                   EQU     H'3FFF'
_CPD_ON                      EQU     H'3EFF'
_CPD_OFF                     EQU     H'3FFF'
_LVP_ON                      EQU     H'3FFF'
_LVP_OFF                     EQU     H'3F7F'
		LIST
		#DEFINE APROCFREQ D'20000000'
		#DEFINE BITSIZE D'14'
		#DEFINE BOOTADDRESS D'0'
		#DEFINE FIRSTRAM H'20'
		#DEFINE LASTRAM H'1FF'
		#DEFINE HASOSCCAL 0
		#DEFINE NPAGESRAM 4
		#DEFINE NPAGESROM 4
;
; APPLICATION DESIGNER GLOBALS
;
		VINTCON=0               ; VALUE LOADED INTO INTCON DURING INITIALISATION
		VOPTION_REG=0X7F        ; VALUE LOADED INTO OPTION REGISTER DURING INTIALISATION
		VPIE1=0                 ; VALUE LOADED INTO PIE1 DURING INTIALISATION
		VPIE2=0                 ; VALUE LOADED INTO PIE2 DURING INTIALISATION
		VTRISA=0XFF             ; VALUE LOADED INTO TRISA DURING INITIALISATION
		VTRISB=0XFF             ; VALUE LOADED INTO TRISA DURING INITIALISATION
		VTRISC=0XFF             ; VALUE LOADED INTO TRISA DURING INITIALISATION
		VTRISD=0XFF             ; VALUE LOADED INTO TRISA DURING INITIALISATION
		VTRISE=0X07             ; VALUE LOADED INTO TRISA DURING INITIALISATION
		VPORTA=0XFF             ; VALUE LOADED INTO PORTA DURING INITIALISATION
		VPORTB=0XFF             ; VALUE LOADED INTO PORTA DURING INITIALISATION
		VPORTC=0XFF             ; VALUE LOADED INTO PORTA DURING INITIALISATION
		VPORTD=0XFF             ; VALUE LOADED INTO PORTA DURING INITIALISATION
		VPORTE=0XFF             ; VALUE LOADED INTO PORTA DURING INITIALISATION
;
; MACROS TO SAVE & RESTORE DURING AN INTERRUPT
;
INTSAVE         MACRO
		MOVWF W_TEMP            ; COPY W TO TEMP REGISTER
		SWAPF STATUS,W          ; SWAP STATUS TO BE SAVED INTO W
		CLRF STATUS             ; BANK 0
		MOVWF STATUS_TEMP       ; SAVE STATUS
		MOVF FSR,W              ; COPY FSR TO W
		MOVWF FSR_TEMP          ; COPY FSR FROM W TO FSR_TEMP
		#IF (4 >1)
		MOVF PCLATH, W          ; ONLY REQUIRED IF USING PAGES 1, 2 AND/OR 3
		MOVWF PCLATH_TEMP       ; SAVE PCLATH INTO W
		CLRF PCLATH             ; PAGE ZERO, REGARDLESS OF CURRENT PAGE
		#ENDIF
		ENDM
INTRECALL       MACRO
		#IF (4 >1)
		MOVF  PCLATH_TEMP,W    ; RESTORE PCLATH
		MOVWF PCLATH           ; MOVE W INTO PCLATH
		#ENDIF
		SWAPF STATUS_TEMP,W     ; SWAP STATUS_TEMP REGISTER INTO W
		MOVWF STATUS            ; MOVE W INTO STATUS REGISTER
		SWAPF W_TEMP,F          ; SWAP W_TEMP
		SWAPF W_TEMP,W          ; SWAP W_TEMP INTO W
		ENDM
;
; LONG CALL MACRO - THIS SETS THE PAGING BITS, IT ASSUMES PCLATH  
; IS CURRENTLY CLEAR, AND ONLY SETS PCLATH IF THE LABEL IS UNKNOWN (I.E. A
; FORWARD REFERENCE), OR IT IS KNOWN AND IS NOT IN PAGE 0. IT IS THEREFORE MORE
; EFFICIENT THAN MICROCHIP'S LCALL MACRO WHICH ALWAYS SETS THE PAGING BITS
;
; IT ONLY SETS THE BITS IF THERE IS MORE THAN 1 PAGE OF ROM.
;
LONGCALL        MACRO N
		IF (4 >1)
		IF ((!N) || (N>$) || N>=0X800)       ; MUST SET PAGING BITS
		IF (N&0X800)
		BSF PCLATH,3
		ELSE
		BCF PCLATH,3
		ENDIF
		IF (4 >2)     ; TEST 2ND ROM PAGES
		IF (N&0X1000)
		BSF PCLATH,4
		ELSE
		BCF PCLATH,4
		ENDIF
		ENDIF
		ENDIF
		ENDIF
		CALL N                ; ONE PAGES OF ROM SO SIMPLE CALL
		ENDM
;
; THIS IS DIFFERENT, IT SETS THE PCLATH BITS ON THE ASSUMPTION THAT THEY
; ARE NOT ALREADY KNOWN
;                
ADSETPCLATH    MACRO N			; SET PCLATH BITS
		IF (4 >1)
		IF (N&0X800)
		BSF PCLATH,3
		ELSE
		BCF PCLATH,3
		ENDIF
		IF (4 >2)
		IF (N&0X1000)
		BSF PCLATH,4
		ELSE
		BCF PCLATH,4
		ENDIF
		ENDIF
		ENDIF  
		ENDM
;
; CLEAR PCLATH IF IT WAS SET IN A CALL, IF N IS 0 THEN ALWAYS CLEAR IT
; ONLY CLEAR IT IN ANY CASE IF MORE THAN 1 PAGE OF ROM
;
CLEARPCLATH     MACRO N
		IF (((N>H'7FF') || (N==0)) && (4 >1))
		#IF N&0X800
		BCF PCLATH,3
		#ENDIF
		#IF N&0X800
		BCF PCLATH,4
		#ENDIF
		ENDIF
		ENDM
;
; VARIABLES FOR INTERRUPTS
;
		CBLOCK H'20' +0X180
		CBLOCK H'20' +0X100
		CBLOCK H'20' +0X80
		CBLOCK H'20' 
		CBLOCK
;
; MACROS FOR PAGE SWITCHING VARIABLES
; NOTE WE ASSUME THAT ALL ROUTINES SET RP0 AND RP1 BACK TO 0 BEFORE RETURNING
;
ADSETRP		MACRO N
		IF N&0X80
		BSF STATUS,RP0
		ENDIF
		IF N&0X100
		BSF STATUS,RP1
		ENDIF
		ENDM
ADCLEARRP	MACRO N
		IF N&0X80
		BCF STATUS,RP0
		ENDIF
		IF N&0X100
		BCF STATUS,RP1
		ENDIF
		ENDM
;
; SET IRP FOR INDIRECT ACCESS
; 
ADSETIRP	MACRO N
		IF 4 >2
		IF (N&0X100)
		BSF STATUS,IRP
		ELSE
		BCF STATUS,IRP
		ENDIF
		ENDIF
		ENDM
;
; CORRECT A POINTER TO VARIABLES SO THAT THEY ALL FIT IN THE SAME MEMORY BLOCK
;
FITINBLOCK 	MACRO START,SIZE
		#IF ((START&0X7F)+SIZE)>0X80
		START=((START+0X80)&0X180)+0X21
		#ENDIF
		ENDM
;
; FORCE A FUNCTION OF SIZE : ALLOW TO FIT INTO ONE PAGE OF ROM
;
MFORCEPAGE	MACRO ALLOW
		LOCAL NEXT
		NEXT=($+ALLOW+32)&0XF800	
		IF ($&0XF800)!=NEXT
		ORG NEXT
		ENDIF
		ENDM
;
; THIS MACRO DELAYS AN EXACT
; NUMBER OF CLOCK CYCLES BETWEEN
; 1 AT MINIMUM OR 186420 AT MAX
;
		DELV=0
DELAY MACRO CYC
		IF (CYC<D'10' || CYC>D'186420')
		SMALLCYC=CYC
		IF (SMALLCYC&1)
		NOP
		SMALLCYC-=1
		ENDIF
		WHILE(SMALLCYC)
		GOTO DEL#V(DELV)
		DEL#V(DELV)
		DELV=DELV+1
		SMALLCYC-=2
		ENDW
		ELSE
		SMALLCYC=CYC
		IF CYC>D'777'
		ADSETPCLATH BIGDEL		; 2 CYCLES ALWAYS
		BIGCYC=(CYC-D'730')
		LOOPDELAY=BIGCYC/D'728'
		MOVLW LOOPDELAY+1
		CALL BIGDEL
		SMALLCYC=CYC-(D'730'+LOOPDELAY*D'728'+5)
		ENDIF
		ADSETPCLATH DELAY0		; 2 CYCLES ALWAYS
		LOOPDELAY=(SMALLCYC-5)-5 	; DELAY<=775 CYC
		MOVLW LOOPDELAY/3+1
		CALL DELAY0-LOOPDELAY%3
		ENDIF
		ENDM
; **********
;
; PROVIDES A SOFTWARE STACK
;
; **********
		#DEFINE STACKUSED 1
; **********
;
; 16 BIT MULTIPLY
;
; **********
		#DEFINE MULDUSED 1
; **********
;
; 16 BIT DIVIDE & MOD FUNCTION
;
; **********
		#DEFINE MODDIVDUSED 1
; **********
;
; MATHS - UTILITY OPERATIONS
;
; **********
		#DEFINE UTILITYUSED 1
; **********
;
; APPLICATION DESIGNER VARIABLES
;
; **********
		CBLOCK
; DEFINES SPECIFIED BY 1 OR MORE ELEMENTS
		#DEFINE _PREPMD16 1
		#DEFINE INC2DUSED 1
		#DEFINE INCDUSED 1
		#DEFINE MATHS 1
		#DEFINE MODDIVD 1
		#DEFINE NEG2DUSED 1
		#DEFINE NEGDUSED 1
; *** INPUT FILE - C:\PROGRAM FILES\FED\WIZPIC\APPWIZ\MATHS.INC
		CBLOCK 
;
; DEFINE THE ACCUMULATORS
;
		CBLOCK
		#DEFINE ACCL ACC
		#DEFINE ACC2L ACC2
LOADACCA 	MACRO	V	; MACRO TO LOAD A CONSTANT TO ACC
		IF (V!=0)
		MOVLW V
		MOVWF ACC
		ELSE
		CLRF ACC
		ENDIF
		ENDM
LOADACCD 	MACRO	V	; MACRO TO LOAD A CONSTANT TO ACC
		IF (V==0)
		CLRF ACC
		CLRF ACCH
		ELSE
		MOVLW V
		MOVWF ACC
		IF (V>0 && V<D'256')
		CLRF ACCH
		ELSE
		MOVLW V>>8
		MOVWF ACCH
		ENDIF
		ENDIF
		ENDM
LOADACC2A 	MACRO	V	; MACRO TO LOAD A CONSTANT TO ACC2
		IF (V!=0)
		MOVLW V
		MOVWF ACC2
		ELSE
		CLRF ACC2
		ENDIF
		ENDM
LOADACC2D 	MACRO	V	; MACRO TO LOAD A CONSTANT TO ACC2
		IF (V==0)
		CLRF ACC2
		CLRF ACC2H
		ELSE
		MOVLW V
		MOVWF ACC2
		IF (V>0 && V<D'256')
		CLRF ACC2H
		ELSE
		MOVLW V>>8
		MOVWF ACC2H
		ENDIF
		ENDIF
		ENDM
;
; THIS FILE IS AUTOMATICALLY GENERATED. ANY CHANGES WILL BE OVERWRITTEN WHEN
; THE APPLICATION IS REGENERATED
;
		ORG 0
		NOP			; LEAVE CLEAR FOR IN CIRCUIT DEBUGGER
		CLRF PCLATH            ; RESET PROGRAM PAGE BITS
		GOTO START
;
; INTERRUPTS
;
		ORG 4
		MOVWF W_TEMP            ; COPY W TO TEMP REGISTER
		SWAPF STATUS,W          ; SWAP STATUS TO BE SAVED INTO W
		CLRF STATUS             ; BANK 0
		MOVWF STATUS_TEMP       ; SAVE STATUS
		MOVF FSR,W              ; COPY FSR TO W
		MOVWF FSR_TEMP          ; COPY FSR FROM W TO FSR_TEMP
		MOVF PCLATH, W          ; ONLY REQUIRED IF USING PAGES 1, 2 AND/OR 3
		MOVWF PCLATH_TEMP       ; SAVE PCLATH INTO W
		CLRF PCLATH             ; PAGE ZERO, REGARDLESS OF CURRENT PAGE
INTPRI:                                 ; PRIORITY INTERRUPTS HERE
		GOTO USERINTERRUPT
AUTOINT:
		MOVF  PCLATH_TEMP,W    ; RESTORE PCLATH
		MOVWF PCLATH           ; MOVE W INTO PCLATH
		SWAPF STATUS_TEMP,W     ; SWAP STATUS_TEMP REGISTER INTO W
		MOVWF STATUS            ; MOVE W INTO STATUS REGISTER
		SWAPF W_TEMP,F          ; SWAP W_TEMP
		SWAPF W_TEMP,W          ; SWAP W_TEMP INTO W
		RETFIE
;
; INITIALISATION - INITIALISE ELEMENTS IN TURN
;
START:
		CLRF STATUS            ; RESET RAM PAGE BITS
		CLRF INTCON            ; DISABLE INTERRUPTS
		BSF STATUS,RP0
		CLRF PIE1
		CLRF PIE2
		BCF STATUS,RP0
		CLRF FSR               ; POINT TO LOWER RAM PAGE
ADINIT:
		MOVLW H'FF'
		MOVWF SP
		MOVLW VINTCON
		MOVWF INTCON
		MOVLW VPORTA
		MOVWF PORTA
		MOVLW VPORTB
		MOVWF PORTB
		MOVLW VPORTC
		MOVWF PORTC
		MOVLW VPORTD
		MOVWF PORTD
		MOVLW VPORTE
		MOVWF PORTE
		BSF STATUS,RP0
		MOVLW VOPTION_REG
		MOVWF OPTION_REG
		MOVLW VPIE1
		MOVWF PIE1
		MOVLW VPIE2
		MOVWF PIE2
		MOVLW VTRISA
		MOVWF TRISA
		MOVLW VTRISB
		MOVWF TRISB
		MOVLW VTRISC
		MOVWF TRISC
		MOVLW VTRISD
		MOVWF TRISD
		MOVLW VTRISE
		MOVWF TRISE
		BCF STATUS,RP0
ADINITEND:
		CALL USERINITIALISE
		BSF INTCON,GIE          ; FINALLY ENABLE INTERRUPTS
;
; MAIN LOOP - HANDLE OCCURRENCES AS THEY ARE FLAGGED
;
MAIN:
		GOTO USERLOOP
;
; LOAD OSCILLATOR CALIBRATION VALUE ON RESET FOR 14 BIT PROCESSORS
;
; ROBOTLEG10
; 12TH DEC 2002 - VERSION THAT DRIVES 8 SERVOS
; PLUS WORKING SERVO VALUE INTERPOLATION ROUTINES
; PLUS RELOCATION OF VARIABLES TO AVOID LOCATIONS USED BY THE MATHS ROUTINES
; INTERPOLATE OFF FLAG 5D BIT 1 ADDED
; LDELAY2 ROUTINE ADDED TO PROVIDE EXTENDED MOVEMENT OF SERVOS
; USED WITH FLAG 5D BITS 4 (FOR UPPER LEG SERVOS) & 5 (FOR LOWERLEG SERVOS)
; GIVES SERVO PULSE WIDTH RANGE FROM 0.75MS TO 2.25 MS INSTEAD OF 1 TO 2 MS
; SINGLE STEP ON KEY HIT CODE ADDED. USED WHEN 5D FLAG BIT 0 IS SET
; EXTRA LED SET , CLEAR AND TOGGLE ROUTINES FOR LEDS 1 & 4
; MODIFIED KEY SETTINGS AT START
; TIMER LOOP MINIMISE FLAG CODE AND KEY INPUTS SKIP FOR RUNNING IN SIMULATE MODE
; BRING THE GETTING NEXT SERVO VALUE IN LINE WITH SPEED COUNTER - NEED TO START 
; NOW WITH SPEED COUNTER SET TO SPEED VALUE. REMOVES INTERPOLATE JUMP PROBLEM.
; MOVE SOME SET UP CODE ABOVE 4K BOUNDARY.
; 
; USER DEFINED CODE 
;*******************************************************************************
;
; INSERT YOUR INTERRUPT HANDLING CODE IF REQUIRED HERE. YOUR CODE SHOULD FINISH
; WITH THE LINE "GOTO AUTOINT"
;
USERINTERRUPT:
		GOTO AUTOINT            ; RETURN TO APP DESIGNER INTERRUPTS
;*******************************************************************************
;
; INSERT YOUR INITIALISATION CODE IF REQUIRED HERE. YOUR CODE SHOULD FINISH WITH
; THE LINE "RETURN". NOTE THAT WHEN THIS ROUTINE IS CALLED INTERRUPTS WILL NOT
; BE ENABLED - THE APPLICATION DESIGNER WILL ENABLE THEM BEFORE THE MAIN LOOP
;
USERINITIALISE:
		RETURN            ; RETURN TO APP DESIGNER
;*******************************************************************************
;
; INSERT YOUR MAIN LOOP CODE IF REQUIRED HERE. YOUR CODE SHOULD FINISH WITH
; THE LINE "GOTO MAIN"
;
;SERVO CONTROL PROGRAM
		LIST    P=16F877
		RADIX   HEX
USERLOOP:  
L00       NOP                 ;
		CLRF    STATUS      ; CLEAR STATUS REG
		GOTO    L03         ;
L03       CALL    L0A         ; CLEAR BANK 0 & 1 DATA REGISTER AREAS
; ON ORIGINAL CODE THIS WOULD BE THE INTERRUPT VECTOR POINT - PROGRAM LOCN 04H
		BSF     STATUS,IRP  ; SET BIT 7 (IRP) OF STATUS - REG BANK 2 & 3
		MOVLW   H'20'       ; LOAD W REG WITH VALUE 20H
		CALL    L0B         ; CLEAR BANK 2 & 3 DATA REGISTER AREAS
;
		MOVLW   H'EF'       ; LOAD W REG WITH VALUE EFH
		MOVWF   H'7C'       ; SAVE W REG IN LOCATION 7CH
		BCF     STATUS,IRP  ; CLEAR BIT 7 (IRP) OF STATUS - REG BANK 0 & 1    
		GOTO    L31         ;
; ROUTINE TO CLEAR 80 DATA BYTES IN CURRENT DATA BANK FROM LOCATION DEFINED BY 
; W REGISTER. USES LOCATION 20H AS A WORKING COUNTER
L0A       MOVLW   H'21'       ; LOAD W REG WITH VALUE 21H (START ADDRESS)
L0B       CALL    L0D         ; CALL L0D TO CLEAR 80 BYTES OF DATA
		MOVLW   H'A0'       ; LOAD W REG WITH VALUE A0H (START ADDRESS)
; FOLLOWING CODE CLEARS 80 BYTES OF DATA FROM LOCATION SPECIFIED IN W REGISTER
L0D       MOVWF   FSR         ; SAVE W REG IN FSR
		MOVLW   H'50'       ; LOAD W REG WITH VALUE 50H
		MOVWF   H'20'       ; SAVE W REG IN LOCATION 20H
L10       CLRF    H'00'       ; CLEAR LOCATION POINTED TO BY FSR
		INCF    FSR         ; ADD 1 TO FSR
		DECFSZ  H'20'       ; SUBTRACT 1 FROM DATA LOCATION 20H, SKIP IF ZERO
		GOTO    L10         ; GO ROUND LOOP
L14       RETURN              ;
; INITIALISATION CODE TO SET UP THE TRIS BUFFERS FOR PORTE D AND E IN BANK 1
L31       CLRF    PCLATH      ; CLEAR PCLATH
		GOTO    L33         ;
L33       BSF     STATUS, RP0 ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'07'       ; LOAD W REGISTER WITH VALUE 07H         
		MOVWF   ADCON1      ; SAVE W REG IN ADCON1
		MOVLW   H'03'       ; LOAD W REGISTER WITH VALUE 03H 
		MOVWF   TRISE       ; SAVE W REG IN TRISE
		MOVLW   H'0F'       ; LOAD W REGISTER WITH VALUE 0FH 
		MOVWF   TRISD       ; SAVE W REG IN TRISD - SET BITS 0-3, CLEAR 4-7
		CLRF    TRISB       ; CLEAR TRISB ALL OUTPUTS - FOR SERVOS
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		BCF     PORTD,4     ; CLEAR BIT 4 OF PORTD - SWITCH OFF LED 1
		BCF     PORTD,5     ; CLEAR BIT 5 OF PORTD - SWITCH OFF LED 2
		BCF     PORTD,6     ; CLEAR BIT 6 OF PORTD - SWITCH OFF LED 3
		BCF     PORTD,7     ; CLEAR BIT 7 OF PORTD - SWITCH OFF LED 4
		CLRF    H'58'       ; CLEAR FLAG FOR PORT D VALUES
		BSF     PORTE,2     ; SET BIT 2 OF PORTE - ENABLE LEDS
		CLRF    H'6A'       ; CLEAR FLAG FOR PORT B VALUES       
		MOVLW   H'32'       ; INITIALISE LED TOGGLE COUNTER TO VALUE 50  
		MOVWF   H'59'       ; SAVE IN LOCATION 59H               
		MOVLW   H'10'       ; INITIALISE SPEED COUNTER TO VALUE 16
		MOVWF   H'5E'       ; SAVE IN LOCATION 5EH
		MOVWF   H'5F'       ; SET THE CURRENT SPEED VALUE TO SAME AS COUNTER
		MOVLW   H'A0'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'48'       ; SAVE IN LOCATION 48H - FOR LOWER SERVO LEG 1
		MOVLW   H'B4'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'4A'       ; SAVE IN LOCATION 4AH - FOR UPPER SERVO LEG 1
		MOVLW   H'C8'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'3A'       ; SAVE IN LOCATION 3AH - FOR LOWER SERVO LEG 2
		MOVLW   H'DC'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'3C'       ; SAVE IN LOCATION 3CH - FOR UPPER SERVO LEG 2
		MOVLW   H'A0'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'40'       ; SAVE IN LOCATION 40H - FOR LOWER SERVO LEG 3
		MOVLW   H'B4'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'42'       ; SAVE IN LOCATION 42H - FOR UPPER SERVO LEG 3
		MOVLW   H'C8'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'44'       ; SAVE IN LOCATION 44H - FOR LOWER SERVO LEG 4
		MOVLW   H'DC'       ; INITIALISE POSITION POINTER TO LIST START LOCN
		MOVWF   H'46'       ; SAVE IN LOCATION 46H - FOR UPPER SERVO LEG 4
		CLRF    H'37'       ; CLEAR PREVIOUS PORTD VALUE FOR KEYTEST RTN  
		CLRF    H'5B'       ; CLEAR LED TOGGLES 
		CLRF    H'5D'       ; CLEAR THE SPECIAL ROUTINES TO RUN FLAG  
		MOVLW   H'10'       ; LOAD 16 (STRAIGHT  ON) INTO TURN VALUE
		MOVWF   H'6E'       ; SAVE IT IN LOCATION H'6E'
; SET UP SERVO POSITION LISTS FOR UPPER AND LOWER PART OF EACH LEG FOR WALKING
; SET SIMULATE FLAGS ON HERE IF NEEDED	 - COMMENT OUT FOR CORRECT OPERATION 
;BSF     H'5D',3 	; GENERAL SIMULATE FLAG + SKIP KEY TESTS
;BSF     H'5D',2	; REDUCE TIMER LOOPS TO MIN
		BTFSS   H'5D',3 	
		GOTO 	  GETKEY                                         
SIMUL	  BSF	  H'5D',4	; SET EXTENDED RANGE FLAGS FOR SIMULATE
		BSF	  H'5D',5  	; SET EXTENDED RANGE FLAGS FOR SIMULATE
		MOVLW   H'04'         ; SET TO RUN FAST SPEED
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH
		MOVWF   H'5F'         ; SAVE IN LOCATION 5FH
		GOTO    MAINPROG
; BEFORE GOING IN TO MAIN LOOP WAIT FOR A KEY TO BE PRESSED
; AND THEN RUN A PROGRAM OR VARIANT ACCORDING TO WHICH KEY PRESSED	
GETKEY	  NOP
		BTFSC   H'5D',3      ; IF RUNNING IN SIMULATION MODE SKIP KEY TESTS
		GOTO    SIMUL        ; TEMP FIX FOR SIMULATION TO REMOVE KEYTEST ***
		CALL 	  WAITKEY      ; WAIT FOR ANY KEY TO BE HIT
; TEST WHICH KEY HAS BEEN HIT   
TESTK2    BTFSC   H'39',1      ; CHECK IF KEY 2 IS PRESSED
		GOTO    PROG2        ; IF SO GO TO MAIN SERVO PROGRAM LOOP
		BTFSC   H'39',2      ; CHECK IF KEY 3 IS PRESSED
		GOTO    PROG3        ; IF SO GO TO SLOW TROT ROUTINE  
		BTFSC   H'39',0      ; CHECK IF KEY 1 IS PRESSED
		GOTO    PROG1        ; IF SO GO TO TEST PROG 1 
		BTFSC   H'39',3      ; CHECK IF KEY 4 IS PRESSED
		GOTO    PROG4        ; IF SO GO TO COMPETITION ROUTINE	  
		GOTO    GETKEY       ; SHOULD NOT GET HERE BUT IF WE DO, TEST KEYS  
;                                  
KEYTESTS  CALL WAITKEY		; GET NEXT KEY VALUE FOR SINGLE STEP TEST
		BSF   H'5D',0         ; SET STEP SERVOS ON KEY HIT SPECIAL ROUTINE FLAG
		BTFSS H'39',2		; SKIP IF KEY 3 HIT 
		BCF	H'5D',0		; RESET SINGLE STEP FLAG
CALT1	  NOP
		CALL WAITKEY		; GET NEXT KEY VALUE FOR INTERPOLATE TEST
		BSF   H'5D',1         ; SET NO INTERPOLATE SPECIAL ROUTINE FLAG
		BTFSS H'39',2		; SKIP IF KEY 3 HIT 
		BCF	H'5D',1		; RESET 'NO INTEROLATE' FLAG
		CALL WAITKEY		; GET NEXT KEY VALUE FOR EXPANDED RANGE TEST
		BSF  H'5D',4          ; SET EXPANDED RANGE AT HIP FLAG
		BSF  H'5D',5          ; SET EXPANDED RANGE AT KNEE FLAG
		BTFSS H'39',1		; SKIP IF KEY 2 HIT 
		BCF	H'5D',4		; RESET 'EXPANDED RANGE AT HIP' FLAG
		BTFSS H'39',2		; SKIP IF KEY 3 HIT 
		BCF	H'5D',5		; RESET 'EXPANDED RANGE AT KNEE' FLAG
		BTFSS H'39',0		; SKIP IF KEY 1 HIT 
		GOTO	 CALT2
		BSF	H'5D',4		; SET 'EXPANDED RANGE AT HIP' FLAG
		BSF	H'5D',5		; SET 'EXPANDED RANGE AT KNEE' FLAG
CALT2	  NOP
		GOTO    MAINPROG      ; RUN MAIN PROGRAM WITH MODIFIED VALUES
; WALKING PROGRAMS	
;         STAND STILL               
PROG1     CALL PRX1		; STANDSTILL PROGRAM
		GOTO    KEYTESTS      ; GET REST OF KEY VALUES
PRX1	  CALL TOGLED1		; SWITCH LED1 ON    
		BSF PCLATH,3
		BCF PCLATH,4
		CALL STNDSTILL                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'01'         ; LOAD LITERAL 01 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH   
		RETURN  
; WALK PROGRAM          
PROG2     CALL PRX2		; WALK 1 LEG AT A TIME
		GOTO    KEYTESTS	; GET REST OF KEY VALUES
PRX2	  CALL    TOGLED2	; SWITCH LED2 ON OR OFF
		CALL	  LED3CLR	; SWITCH OFF LED 3
		CALL	  LED4CLR	; SWITCH OFF LED 4
		BSF PCLATH,3
		BCF PCLATH,4
		CALL SETWALK1                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'03'         ; LOAD LITERAL 03 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH     
		RETURN
; SLOW TROT PROGRAM         
PROG3     CALL PRX3		; TROT - 2 DIAGONAL LEGS TOGETHER 
		GOTO    KEYTESTS	; GET REST OF KEY VALUES
PRX3	  CALL 	  TOGLED2	; SWITCH LED2 ON OR OFF
		BSF PCLATH,3
		BCF PCLATH,4
		CALL SLOWTROT                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'04'         ; LOAD LITERAL 04 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH      
		RETURN                  	  
;
; COMPETITION PROGRAM	
PROG4     CALL PRX4		; COMPETE PROGRAM
		BCF     H'5D',0	; SWITCH OFF SINGLE STEP
		BCF     H'5D',1       ; SWITCH ON INTERPOLATE   
		BSF     H'5D',4	; EXPAND UPPER SERVO RANGE
		BSF     H'5D',5	; EXPAND LOWER SERVO RANGE
		GOTO    MAINPROG	; RUN MAIN PROGRAM
PRX4	  CALL    LED1SET	; SWITCH LED1 ON
		CALL    LED2SET	; SWITCH LED2 ON
		CALL    LED3SET	; SWITCH LED3 ON
		CALL    LED4SET	; SWITCH LED4 ON  
		BSF PCLATH,3
		BCF PCLATH,4
		CALL READY2                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'02'         ; LOAD LITERAL 02 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET TO RUN FAST SPEED
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH 
		RETURN  
;                  	          	          	  
;         CODE TO SET PROGRAM TO TURN RIGHT
PRX5	  CALL    LED4SET	; SWITCH LED4 ON
		CALL    LED3CLR	; SWITCH LED3 OFF
		BSF PCLATH,3
		BCF PCLATH,4
		CALL TURNRIGHT                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'05'         ; LOAD LITERAL 02 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH     
		RETURN  
;         CODE TO SET PROGRAM TO TURN LEFT
PRX6	  CALL    LED3SET	; SWITCH LED3 ON
		CALL    LED4CLR	; SWITCH LED4 OFF
		BSF PCLATH,3
		BCF PCLATH,4
		CALL TURNLEFT                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'06'         ; LOAD LITERAL 02 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH     
		RETURN    
;         CODE TO SET PROGRAM TO FAST TROT
PRX7	  CALL    LED3SET	; SWITCH LED3 ON
		CALL    LED4CLR	; SWITCH LED4 OFF
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FASTTROT                ; ONE PAGES OF ROM SO SIMPLE CALL
		BSF PCLATH,3
		BCF PCLATH,4
		CALL FIRSTVALS                ; ONE PAGES OF ROM SO SIMPLE CALL
		MOVLW   H'05'         ; LOAD LITERAL 02 INTO W REG
		MOVWF   H'6F'         ; SAVE IT IN PROGRAM VALUE FIELD
		MOVLW   H'10'         ; SET SPEED TO FAST
		MOVWF   H'5E'         ; SAVE IN LOCATION 5EH     
		RETURN    
; ROUTINE THAT WAITS FOR A KEY TO BE HIT. RETURNS VALUE IN H'39'
WAITKEY	  NOP
		CALL    KEYTEST       ; CHECK THE KEYS
		INCF    H'39'         ;
		DECFSZ  H'39'         ; SKIP IF ZERO I.E. NO KEY HIT
		RETURN      		;    RETURN WITH VALUE IN H'39'   
		MOVLW   H'FF'         ; SET UP DELAY AMOUNT
		CALL    LDELAY        ; WAIT FOR A MILLISECOND
		GOTO    WAITKEY       ; IF NO KEY HIT GO ROUND LOOP AGAIN  
;                                                     
MAINPROG  CLRF    H'39'         ; CLEAR INITIAL VALUE OF KEYS BEFORE WE
		GOTO    LSERLOOP      ; GO TO MAIN PROGRAM LOOP
; START OF MAIN LOOP TO SEND A PULSE TO THE SERVOS EVERY 20 MILLISECONDS
LSERLOOP  NOP
; IF NON STD ROUTINES FLAG IS SET GO OFF TO SPECIAL EXTRA ROUTINES
;INCF   H'5D'        ; TEST IF ZERO BY ADDING AND SUBTRACTING 1
;DECFSZ H'5D'        ;
;CALL   SPECRTNS     ; IF NOT ZERO GO OFF TO SPECIAL RTN HANDLER
; ADJUST SPEED 
; IF KEY 2 PRESSED, SPEED UP, AND IF KEY 3 PRESSED, SLOW DOWN
TEST2KEY  BTFSS    H'39',1     	; WAS KEY 2 HIT I.E TO SPEED UP MOVEMENT
		GOTO     TEST3KEY
		DECF     H'5E'       	; REDUCE SPEED DELAY TO INCREASE SERVO SPEED
;IF SPEED COUNTER BECOMES H'EF' SKIP IT DOWN TO 32 (H'20')
		MOVLW    H'EF'      	; LOAD EF INTO W REG
		SUBWF	   H'5E',W 	; SUBTRACT SPEED VALUE - RESULT IN W
		BTFSS	   STATUS,Z	; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   TEST3KEY
		MOVLW    H'20'      	; LOAD 32 INTO W REG
		MOVWF	   H'5E'	; SAVE IN SPEED COUNTER 
TEST3KEY  BTFSS    H'39',2 	; WAS KEY 3 HIT I.E TO SLOW DOWN MOVEMENT
		GOTO     TEST4KEY  
		INCF     H'5E'       	; INCREASE SPEED DELAY TO REDUCE SERVO SPEED
;IF SPEED COUNTER BECOMES 32 BUMP IT UP TO VERY SLOW (F0)
		MOVLW    H'20'      	; LOAD 32 INTO W REG
		SUBWF	   H'5E',W 	; SUBTRACT SPEED VALUE - RESULT IN W
		BTFSS	   STATUS,Z	; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   TEST4KEY
		MOVLW    H'F0'      	; LOAD F0 INTO W REG
		MOVWF	   H'5E'	; SAVE IN SPEED COUNTER
; CHANGE PROGRAM CODE 
; USES LOCATION H'6F' TO INDICATE CURRENT WALKING PROGRAM.
; 1 = STAND STILL, 2 = READY TO WALK, 3 = WALK, 4 = TROT
; IF KEY 4 PRESSED, GO TO NEXT FASTER PROG, IF KEY 1 GO TO PREVIOUS,
TEST4KEY  BTFSS    H'39',3 	; WAS KEY 4 HIT I.E TO TURN RIGHT
		GOTO     TEST1KEY  
; CODE TO MOVE TO FASTER PROGRAM
; IF ALREADY GOING FASTEST DO NOTHING
		MOVF     H'6F',W       ; LOAD PROGRAM NO INTO W
		SUBLW	   H'05'	 ; SUBTRACT VALUE 4 - RESULT IN W  
		BTFSC	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   TEST1KEY  
; MOVE FROM PROGRAM 1 TO PROGRAM 2
		MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'01'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KA  
		MOVLW    H'02'       ; LOAD LITERAL 2 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 2
		CALL     PRX4		; CALL ROUTINE TO GET READY
		GOTO	   TESTKEND	; 
; MOVE FROM PROGRAM 2 TO PROGRAM 3
T4KA	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'02'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KB  
		MOVLW    H'03'       ; LOAD LITERAL 3 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 3
		CALL     PRX2		; CALL ROUTINE TO FASTTROT
		GOTO	   TESTKEND	; 
; MOVE FROM PROGRAM 3 TO PROGRAM 4
T4KB	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'03'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KC  
		MOVLW    H'04'       ; LOAD LITERAL 4 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 4
		CALL     PRX3		; CALL ROUTINE TO SLOW TROT
		GOTO	   TESTKEND	; 
; MOVE FROM PROGRAM 4 TO PROGRAM 5
T4KC	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'04'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KD  
		MOVLW    H'05'       ; LOAD LITERAL 5 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 5
		CALL     PRX7		; CALL ROUTINE TO FAST TROT
		GOTO	   TESTKEND	; 
T4KD	  NOP	
TEST1KEY  BTFSS    H'39',0 	; WAS KEY 1 HIT I.E TO TURN LEFT
		GOTO     TESTKEND  
; CODE TO MOVE TO SLOWER PROGRAM
; IF ALREADY GOING SLOWEST DO NOTHING
		MOVF     H'6F',W       ; LOAD PROGRAM NO INTO W
		SUBLW	   H'01'	 ; SUBTRACT VALUE 1 - RESULT IN W  
		BTFSC	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   TESTKEND  
; MOVE FROM PROGRAM 2 TO PROGRAM 1
		MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'02'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KSA  
		MOVLW    H'01'       ; LOAD LITERAL 1 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 1
		CALL     PRX1		; CALL ROUTINE TO STANDSTILL
		GOTO	   TESTKEND 	; 
; MOVE FROM PROGRAM 3 TO PROGRAM 2
T4KSA	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'03'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KSB  
		MOVLW    H'02'       ; LOAD LITERAL 2 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 2
		CALL     PRX4		; CALL ROUTINE TO GET READY
		GOTO	   TESTKEND 	; 
; MOVE FROM PROGRAM 4 TO PROGRAM 3
T4KSB	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'04'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   T4KSC  
		MOVLW    H'03'       ; LOAD LITERAL 3 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 3
		CALL     PRX2		; CALL ROUTINE TO WALK
		GOTO	   TESTKEND	; 
; MOVE FROM PROGRAM 5 TO PROGRAM 4
T4KSC	  MOVF     H'6F',W       ; LOAD PROG NO INTO W
		SUBLW	   H'05'	 ; SUBTRACT VALUE FOR 1 - RESULT IN W  
		BTFSS	   STATUS,Z	 ; TEST IF ZERO I.E VALUES MATCHED
		GOTO	   TESTKEND  
		MOVLW    H'04'       ; LOAD LITERAL 4 INTO W REG
		MOVWF    H'6F'       ; SAVE IT IN PROGRAM VALUE
;CODE FOR PROGRAM 4
		CALL     PRX3		; CALL ROUTINE TO WALK
		GOTO	   TESTKEND	; 	 	  
TESTKEND  NOP 
; CODE FOR DRIVING SERVO 1
; IF SINGLE STEP ON KEY FLAG IS SET DO NOT DECREASE THE SPEED COUNTER
; UNTIL A KEY IS HIT
LSELST    NOP
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL1L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL1      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
;
		MOVLW  H'01'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'49',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'50',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP1	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 0  
INTTT1    BSF     H'6A',0     ; SET B0 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH  
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	  
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',5	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'	; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT1PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',0     ; SWITCH B0 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	 
; WAIT FOR REST OF 1MS OR 1.5MS IF EXTENDED MOVEMENT 
LWT1REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS
; CODE FOR DRIVING SERVO 2
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL2L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL2      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'02'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'4B',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'51',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP2	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 1  
		BSF     H'6A',1     ; SET B1 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',4	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'	; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT2PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',1     ; SWITCH B1 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT2REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS            
; CODE FOR DRIVING SERVO 3
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL3L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL3      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'03'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'3B',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'52',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP3	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 2  
		BSF     H'6A',2     ; SET B2 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	           
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',5	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'	; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT3PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',2     ; SWITCH B2 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT3REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS        
; CODE FOR DRIVING SERVO 4
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL4L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL4      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'04'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'3D',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'53',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP4	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 3  
		BSF     H'6A',3     ; SET B3 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	             	         
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',4	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'	; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT4PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',3     ; SWITCH B3 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT4REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS      
; CODE FOR DRIVING SERVO 5
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL5L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL5      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'05'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'41',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'54',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP5	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 4  
		BSF     H'6A',4     ; SET B4 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   	         
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',5	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'	; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT5PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',4     ; SWITCH B4 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT5REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS          
; CODE FOR DRIVING SERVO 6
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL6L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL6      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'06'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'43',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'55',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP6	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 5  
		BSF     H'6A',5     ; SET B5 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	           
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',4	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'		; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS                     
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT6PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',5     ; SWITCH B5 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT6REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS        
; CODE FOR DRIVING SERVO 7
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL7L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL7      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'07'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'45',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'56',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP7	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 6  
		BSF     H'6A',6     ; SET B6 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	    
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',5	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'		; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT7PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',5	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',6     ; SWITCH B6 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT7REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',5	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS          
; CODE FOR DRIVING SERVO 8
; NEXT 4 LINES OF CODE SELECTS THE NEXT SERVO POSN FROM THE LIST
; WHEN SPEED COUNTER = SPEED VALUE           
LSEL8L	  MOVF    H'5F',W       ; LOAD SPEED COUNTER INTO W
		SUBWF   H'5E',W	; SUBTRACT FROM SPEED VALUE
		BTFSC	  STATUS,Z 	; TEST ZERO FLAG, SKIP IF DIFF WAS NOT ZERO   
		CALL    NXTSVAL8      ; GET NEXT ITEM FROM THE LOWER SERVO VALUES LIST
		MOVLW  H'08'		; LOAD SERVO NUMBER IN W     
		MOVWF  H'6B'		; SAVE IT IN SN SERVO NUMBER FIELD  
;GET NEXT INTERPOLATED VALUE 
		MOVF    H'47',W
		MOVWF   H'60' 	; SAVE CURRENT SERVO VALUE IN H'60'
		MOVF    H'57',W
		MOVWF   H'61'         ; SAVE NEXT SERVO VALUE IN H'61' 
INTERP8	  CALL	  INTERP  	; RETURNS VALUE IN H67'
;SWITCH SERVO PULSE ON BY SETTING PORT B BIT 7 
		BSF     H'6A',7     ; SET B7 BIT ON
		MOVF    H'6A',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 6AH   
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	             	         
; WAIT FOR A MILLISECOND (THE MINIMUM PULSE LENGTH)
		MOVLW   H'FF'       ; LOAD W REGISTER WITH VALUE FFH 
		BTFSC   H'5D',4	; TEST FOR EXPANDED MOVEMENT FLAG
		MOVLW	  H'C0'		; RESET WAIT TIME TO 0.75MS
		CALL    LDELAY      ; CALL DELAY TIMER TO WAIT FOR 1 MS
;WAIT FOR DURATION OF PULSE AS DEFINED BY CURRENT LIST ITEM
LWT8PULSE MOVF    H'67',W      ; LOAD CURRENT SERVO VALUE IN W   
		BTFSS	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY	; CALL DELAY ROUTINE
		BTFSC	  H'5D',4	; TEST FOR EXTENDED MOVEMENT FLAG
		CALL    LDELAY2	; CALL EXTENDED DELAY ROUTINE
;SWITCH OFF PULSE
		BCF     H'6A',7     ; SWITCH B7 BIT OFF
		MOVF    H'6A',W     ; LOAD W REG WITH UPDATED VALUE 
		MOVWF   PORTB       ; SAVE W REGISTER IN PORTB - SET BITS
		CLRF    PCLATH      ; CLEAR PCLATH	   
; WAIT FOR REST OF 1MS  OR 1.5MS IF EXTENDED MOVEMENT 
LWT8REST  MOVLW   H'FF'       ; PUT 255 IN W REG       
		MOVWF   H'5C'       ; MOVE IT INTO WORKING AREA
		MOVF    H'67',W     ; LOAD LOWER LEG CURRENT VALUE IN W
		SUBWF   H'5C',W     ; SUBTRACT IT FROM 255 LEAVING RESULT IN W
		BTFSS	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG SET
		CALL    LDELAYE      ; WAIT FOR REMAINDER OF THE 1 MS
		BTFSC	  H'5D',4	; SKIP IF EXTEDED MOVEMENT FLAG NOT SET
		CALL    LDELAY2E      ; WAIT FOR REMAINDER OF THE 1.5 MS          
; CODE TO SINGLE STEP FORWARD ONLY WHEN ANY KEY IS HIT     
LSEL9L    BTFSS   H'5D',0	;TEST IF SINGLE STEP ON KEY FLAG IS SET
		GOTO 	  LSEL9A	; SKIP CODE IF FLAG NOT SET
		BTFSC   H'39',0	; TEST IF KEY HIT AND SKIP IF NOT
		GOTO    LSEL9A	; GO TO CODE TO REDUCE SPEED COUNTER
		BTFSC   H'39',1	; TEST IF KEY HIT AND SKIP IF NOT
		GOTO    LSEL9A	; GO TO CODE TO REDUCE SPEED COUNTER
		BTFSC   H'39',2	; TEST IF KEY HIT AND SKIP IF NOT
		GOTO    LSEL9A	; GO TO CODE TO REDUCE SPEED COUNTER
		BTFSC   H'39',3	; TEST IF KEY HIT AND SKIP IF NOT
		GOTO    LSEL9A	; GO TO CODE TO REDUCE SPEED COUNTER
		GOTO    LSEL9END	; IF NO KEYS HIT SKIP CODE TO REDUCE SPEED CTR
LSEL9A    DECFSZ  H'5F'	      ; TEST IF SPEED COUNTER READY TO BE RESET
		GOTO	  LSEL9END    ; SKIP TO END IF NOT
; RESET SPEED COUNTER TO INITIAL VALUE
		MOVF    H'5E',W     ; LOAD SPEED COUNTER INITIAL VALUE IN TO W REG
		MOVWF   H'5F'       ; SAVE IT IN CURRENT SPEED COUNTER VALUE LOCN
LSEL9END  NOP                    
; CALL THE ROUTINE THAT CHECKS IF ANY KEYS HAVE BEEN CLICKED AND SETS THE 
;  RELEVANT LOWER 4 BITS IN 39H FOR ONE TIME ROUND THE MAIN LOOP   
;  BITS ARE SET WHEN THE ITEM IS UNCLICKED, AND LED 2 IS TOGGLED ON & OFF
		CALL    KEYTEST          
; WAIT FOR A FURTHER 2 MS
		MOVLW   H'02'       ; LOAD W REGISTER WITH VALUE 02H (02D)    
		MOVWF   H'71'       ; SAVE W REGISTER IN DATA LOCATION 71H
		CLRF    H'72'       ; CLEAR CONTENTS OF DATA LOCATION 72H
		CLRF    PCLATH      ; CLEAR PCLATH
		BTFSS	  H'5D',4	; SKIP THE WAIT IF EXTENDED MOVEMENT FLAG IS SET
		CALL    L57         ; CALL DELAY TIMER TO WAIT FOR PERIOD REQD          
; EVERY 50 TIMES ROUND THE LOOP TOGGLE LED1 TO SHOW IT IS WORKING
LED1 	  DECFSZ  H'59'       ; REDUCE COUNTER BY 1
		GOTO    LENDLP      ; SKIP IF NOTHING TO DO
		MOVLW   H'32'       ; RESET LED TOGGLE COUNTER BACK TO 50     
		MOVWF   H'59'       ; SAVE IN LOCATION 59H 
		CALL TOGLED1	; TOGGLE LED 1
LENDLP    NOP
		GOTO    LSERLOOP    ; AND GO ROUND LOOP AGAIN
; TEMPORARY TEST ROUTINES GO IN HERE 
TEST1     CALL    TOGLED2
TEST1A    GOTO    TEST1A 
; SUBROUTINES START HERE
; SPECIAL ROUTINES THAT CAN BE SWITCHED ON BY THE CALIBRATE ROUTINE. CALLED AT
; THE START OF EACH LOOP      
SPECRTNS  NOP    
		RETURN
; ROUTINE TO GET THE NEXT LOWER 1ST LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL1  CALL NXTS1B
		MOVF    H'48',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'49',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS1B		; GET NEXT VALUE - RETURNED IN H'49'
		MOVF    H'49',W	; LOAD IT IN W
		MOVWF   H'50'  	; SAVE IT IN H'50'
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'48' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'49' 	; PUT IT BACK 	  	  
		RETURN
NXTS1B	  INCF    H'48'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'48',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'49'       ; SAVE CURRENT SERVO VALUE IN 49H
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'49'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'49'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND1
		MOVLW   H'A0'       ; SET LIST PTR BACK TO 
		MOVWF   H'48'       ; START OF SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 49H
		MOVF    H'48',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'49'       ; SAVE CURRENT SERVO VALUE IN 49H   
LSELEND1  RETURN 
; ROUTINE TO GET THE NEXT UPPER 1ST LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL2  CALL NXTS2B
		MOVF    H'4A',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'4B',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS2B		; GET NEXT VALUE
		MOVF    H'4B',W	; LOAD IT IN W
		MOVWF   H'51'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'4A' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'4B' 	; PUT IT BACK 	
		RETURN
NXTS2B	  INCF    H'4A'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'4A',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'4B'       ; SAVE CURRENT SERVO VALUE IN 4BH
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'4B'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'4B'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND2
		MOVLW   H'B4'       ; SET LIST PTR BACK TO 
		MOVWF   H'4A'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 4BH
		MOVF    H'4A',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'4B'       ; SAVE CURRENT SERVO VALUE IN 4BH        
LSELEND2  RETURN                                                   
; ROUTINE TO GET THE NEXT UPPER 2ND LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL3  CALL NXTS3B
		MOVF    H'3A',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'3B',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS3B		; GET NEXT VALUE
		MOVF    H'3B',W	; LOAD IT IN W
		MOVWF   H'52'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'3A' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'3B' 	; PUT IT BACK 	
		RETURN
NXTS3B	  INCF    H'3A'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'3A',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'3B'       ; SAVE CURRENT SERVO VALUE IN 3BH
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'3B'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'3B'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND3
		MOVLW   H'C8'       ; SET LIST PTR BACK TO 
		MOVWF   H'3A'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 3BH
		MOVF    H'3A',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'3B'       ; SAVE CURRENT SERVO VALUE IN 3BH        
LSELEND3  RETURN                                                   
; ROUTINE TO GET THE NEXT LOWER 2ND LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL4  CALL NXTS4B
		MOVF    H'3C',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'3D',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS4B		; GET NEXT VALUE
		MOVF    H'3D',W	; LOAD IT IN W
		MOVWF   H'53'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'3C' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'3D' 	; PUT IT BACK 	
		RETURN
NXTS4B	  INCF    H'3C'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'3C',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'3D'       ; SAVE CURRENT SERVO VALUE IN 3DH
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'3D'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'3D'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND4
		MOVLW   H'DC'       ; SET LIST PTR BACK TO 
		MOVWF   H'3C'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 3DH
		MOVF    H'3C',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'3D'       ; SAVE CURRENT SERVO VALUE IN 3DH        
LSELEND4  RETURN                                                   
; ROUTINE TO GET THE NEXT UPPER 3RD LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL5  CALL NXTS5B
		MOVF    H'40',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'41',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS5B		; GET NEXT VALUE
		MOVF    H'41',W	; LOAD IT IN W
		MOVWF   H'54'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'40' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'41' 	; PUT IT BACK 	
		RETURN
NXTS5B	  INCF    H'40'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'40',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		BSF      STATUS,IRP ; POINT TO BANK 2& 3 OF DATA AREA
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'41'       ; SAVE CURRENT SERVO VALUE IN 41H
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'41'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'41'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND5
		MOVLW   H'A0'       ; SET LIST PTR BACK TO 
		MOVWF   H'40'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 41H
		MOVF    H'40',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'41'       ; SAVE CURRENT SERVO VALUE IN 41H        
LSELEND5  BCF     STATUS,IRP  ; POINT BACK TO BANK 0 & 1 OF DATA AREA
		RETURN                                                   
; ROUTINE TO GET THE NEXT LOWER 3RD LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL6  CALL NXTS6B
		MOVF    H'42',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'43',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS6B		; GET NEXT VALUE
		MOVF    H'43',W	; LOAD IT IN W
		MOVWF   H'55'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'42' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'43' 	; PUT IT BACK 	
		RETURN
NXTS6B	  INCF    H'42'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'42',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		BSF     STATUS,IRP  ; POINT TO BANK 2& 3 OF DATA AREA
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'43'       ; SAVE CURRENT SERVO VALUE IN 43H
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'43'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'43'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND6
		MOVLW   H'B4'       ; SET LIST PTR BACK TO 
		MOVWF   H'42'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 43H
		MOVF    H'42',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'43'       ; SAVE CURRENT SERVO VALUE IN 43H        
LSELEND6  BCF     STATUS,IRP  ; POINT BACK TO BANK 0 & 1 OF DATA AREA
		RETURN                                                   
; ROUTINE TO GET THE NEXT UPPER 4TH LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL7  CALL NXTS7B
		MOVF    H'44',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'45',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS7B		; GET NEXT VALUE
		MOVF    H'45',W	; LOAD IT IN W
		MOVWF   H'56'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'44' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'45' 	; PUT IT BACK 	
		RETURN
NXTS7B	  INCF    H'44'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'44',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		BSF      STATUS,IRP ; POINT TO BANK 2& 3 OF DATA AREA
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'45'       ; SAVE CURRENT SERVO VALUE IN 45H
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'45'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'45'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND7
		MOVLW   H'C8'       ; SET LIST PTR BACK TO 
		MOVWF   H'44'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 45H
		MOVF    H'44',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'45'       ; SAVE CURRENT SERVO VALUE IN 45H        
LSELEND7  BCF     STATUS,IRP  ; POINT BACK TO BANK 0 & 1 OF DATA AREA
		RETURN                                                   
; ROUTINE TO GET THE NEXT LOWER 4TH LEG SERVO VALUE FROM THE LIST. 
;  IT LOOPS ROUND WHEN IT DETECTS THE END AS INDICATED BY A ZERO VALUE    
; INCREMENT SERVO LIST POINTER
NXTSVAL8  CALL NXTS8B
		MOVF    H'46',W
		MOVWF   H'68' 	; SAVE H'48' IN TEMP LOCATION H'68'
		MOVF    H'47',W
		MOVWF   H'69'   	; SAVE H'49' IN TEMP LOCATION H'69'
		CALL NXTS8B		; GET NEXT VALUE
		MOVF    H'47',W	; LOAD IT IN W
		MOVWF   H'57'  	; SAVE IT 
		MOVF    H'68',W	; GET PREVIOUS VALUE
		MOVWF   H'46' 	; PUT IT BACK 	  
		MOVF    H'69',W	; GET PREVIOUS VALUE
		MOVWF   H'47' 	; PUT IT BACK 	
		RETURN
NXTS8B	  INCF    H'46'       ; MOVE POINTER TO NEXT SERVO LOCATION
		MOVF    H'46',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		BSF      STATUS,IRP ; POINT TO BANK 2& 3 OF DATA AREA
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'47'       ; SAVE CURRENT SERVO VALUE IN 47H
;IF POINTER IS AT END OF LIST SET IT BACK TO BEGINNING OF LIST       
		INCF    H'47'       ; TEST IF ZERO BY ADDING AND SUBTRACTING ONE
		DECFSZ  H'47'	      ; SKIP IF ZERO I.E. IF AT END OF LIST
		GOTO    LSELEND8
		MOVLW   H'DC'       ; SET LIST PTR BACK TO 
		MOVWF   H'46'       ; START OF UPPER LEG SERVO LOCN LIST
; LOAD VALUE FROM FIRST SERVO LOCATION INTO LOCN 47H
		MOVF    H'46',W     ; LOAD POINTER IN TO W REG
		MOVWF   FSR         ; SAVE IT IN INDIRECT ADDRESSING LOCATION
		MOVF    H'00',W     ; LOAD NEW VALUE INTO W REG
		MOVWF   H'47'       ; SAVE CURRENT SERVO VALUE IN 47H        
LSELEND8  BCF     STATUS,IRP  ; POINT BACK TO BANK 0 & 1 OF DATA AREA
		RETURN                                                   
;ROUTINE TO CALCULATE THE INTERPOLATED VALUE FOR THE SERVOS  
; IT CALCULATES FV=CS+(SV-SC)*(NS-CS)/SV
;	INPUT VALUES:
;		 SV IN H'5E' 8 BIT SPEED VALUE
;		 SC IN H'5F' 8 BIT SPEED COUNTER (REDUCES FROM SPEED VALUE TO ZERO)
;		 CS IN H'60' 8 BIT CURRENT SERVO VALUE		 
;		 NS IN H'61' 8 BIT NEXT SERVO VALUE
;	OTHER FIELDS USED	 
;		 ISC    ;(SV-SC) 8 BIT INVERSE OF SPEED COUNTER
;		 SDIFF	;(NS-CS) 8 BIT DIFFERENCE 
;		 DSIGN  ;1 IF NS-CS IS NEGATIVE
;		 NEGD1   ; SET TO 1 IF SDIFF WOULD BE NEGATIVE
;		 IV	;8 BIT CALCULATED INCREMENTAL VALUE RESULT
;	RETURNED VALUE
;		 FV IN H'67'; 8 BIT FINAL VALUE   
INTERP		NOP
; NEXT 5 LINES DUMMY OUT THE INTERPOLATE ROUTINEIF REQUIRED
		BTFSS   H'5D',1	; TEST INTERPOLATE OFF FLAG
		GOTO    INTRUN	; SKIP TO INTERPOLATE ROUTINE
		MOVF	H'60',W	; GET CURRENT SERVO VALUE
		MOVWF   H'67'	; SAVE IT IN RETURN VALUE
		GOTO    DCALCEND
; PERFORM INTERPOLATE CALCULATION
; CALCULATE ISC 
INTRUN 		MOVF	H'5F',W	; LOAD W REG WITH SPEED COUNTER
		SUBWF	H'5E',W ; SUBTRACT SPEED VALUE - RESULT IN W
		MOVWF   H'62'	; SAVE IN ISC
; CALCULATE DIFF AND WHETHER NEGATIVE
		MOVLW	H'00'	;LOAD DEFAULT VALUE
		MOVWF	H'65'	;SAVE IN NEGD1					
		MOVF	H'61',W	; LOAD W REG WITH NEXT SERVO VALUE	
		SUBWF	H'60',W ; SUBTRACT CURRENT SERVO VALUE -RESULT IN W
		MOVWF   H'63'	; SAVE IN SDIFF	
		BTFSC	STATUS,Z ; TEST ZERO FLAG, SKIP IF DIFF WAS ZERO
		GOTO    DCALC3	; DON'T INTERPOLATE IF DIFF WAS ZERO	
		BTFSC	STATUS,C ; TEST CARRY FLAG, SKIP IF DIFF WAS NEGATIVE
		GOTO    DCALC1	; GO TO END OF DIFFCALC IF DIFF WAS POSITIVE
; SET NEGD1 FLAG AND CONVERT SDIFF TO CORRESPONDING POSITIVE VALUE	
		MOVLW	H'01'	; LOAD VALUE TO SHOW SDIFF WAS NEGATIVE
		MOVWF	H'65'	; SAVE IT IN NEGD1
		COMF    H'63'	; COMPLEMENT IT
		INCF	H'63'	; AND ADD 1 TO GET POSITIVE VALUE
DCALC1		NOP	
		CLRF ACC
		CLRF ACCH
		CLRF ACC2
		CLRF ACC2H
		MOVLW	H'63' 	; PUT SDIFF ADDRESS IN W
		CALL    LOADAFROMW ; PUT SDIFF IN ACC
		CALL    SWAPAA2	; MOVE SDIFF INTO ACC2
		MOVLW	H'62' 	; PUT ISC ADDRESS IN W
		CALL    LOADAFROMW ; PUT ISC IN ACC
		CALL    MULUSD	; MULTIPLY THEM, RESULT STORED IN ACC
		MOVLW   H'6C'	;POINT TO TEMP STORAGE AREA
		CALL    SAVEDTOW ; SAVE 16 BIT RESULT IN TEMP AREA
		CLRF ACC
		CLRF ACCH
		MOVLW	H'5E'	; PUT SV ADDRESS IN W
		CALL    LOADAFROMW ; PUT SV IN ACC
		CALL    SWAPAA2	; MOVE SV TO ACC2
		MOVLW   H'6C'	; POINT TO TEMP STORAGE AREA	
		CALL    LOADDFROMW ; GET PREVIOUS 16 BIT CALULATION FROM TEMP AREA
		CALL    DIVD	; DIVIDE BY SV RESULT IS IN ACC
		MOVLW   H'66' 	; PUT IV ADDRESS IN W
		CALL    SAVEATOW ; PUT RESULT IN IV
; ADD OR SUBTRACT INTERVAL VALUE TO OR FROM CURRENT SERVO VALUE 
		DECFSZ  H'65'    ; TEST NEGATIVE FLAG
		GOTO	DCALC2	;
; SUBTRACT IV VALUE FROM CS PUT IN FV
		MOVF    H'66',W	; PUT IV IN W
		ADDWF   H'60',W	; ADD IT TO CS, RESULT IN W	
		MOVWF   H'67'	; SAVE W IN FINAL VALUE
		GOTO	DCALCEND
DCALC2		NOP		; ADD IV VALUE TO CS & PUT IN FV	
		MOVF    H'66',W	; PUT IV IN W
		SUBWF   H'60',W	; SUBTRACT FROM CS, RESULT IN W
		MOVWF   H'67'	; SAVE W IN FINAL VALUE
		GOTO    DCALCEND
DCALC3		MOVF    H'60',W	; PUT CS IN W
		MOVWF   H'67'	; SAVE W IN FINAL VALUE
DCALCEND	NOP		
		RETURN                                                     
; ROUTINE THAT CHECKS WHETHER A KEY HAS BEEN CLICKED ON AND THEN OFF
; THE 4 KEYS ARE CONNECTED TO LOWER 4 BITS OF PORT D
; IT USES LOCATIONS 37H, 38H AND RETURNS RESULTS IN LOWER 4 BITS OF LOCATION 39H
; IT SETS THE RETURN VALUE AND TOGGLES LED 2 AS EACH KEY IS RELEASED, SO THAT 
; ONLY ONE TRIGGER IS GIVEN EVEN IF THE KEY IS HELD DOWN.
KEYTEST   CLRF    H'39'	      ; RESET KEYS CLICKED FIELD
; SAVE CURRENT PORTD VALUES IN 38H
		MOVF    PORTD,W     ; PUT CURRENT VALUE OF PORTD IN W
		ANDLW   H'0F'       ; CLEAR TOP 4 BITS
		MOVWF   H'38'       ; SAVE CURRENT VALUE IN 38H  
; CHECK IF BIT 0 WAS SET THE PREVIOUS TIME AROUND
KEYBIT0   BTFSS   H'37',0     ; LOOK AT PREVIOUS PORTD BIT 0 VALUE
		GOTO    KEYBIT1     ; IF ZERO, NOTHING TO DO BUT CHECK NEXT BIT
; CHECK IF BIT 0 IS SET NOW 
		BTFSC   H'38',0     ; LOOK AT CURRENT PORTD BIT 0 VALUE
		GOTO    KEYBIT1     ; IF ONE, NOTHING TO DO BUT CHECK NEXT BIT
; ONLY GET HERE IF PREVIOUS WAS 1 AND CURRENT IS ZERO I.E. SWITCH
; HAS CLICKED OFF
		BSF     H'39',0     ; SET RESULT FLAG BIT 0
		CALL    TOGLED2     ; TOGGLE LED 2      
; CHECK IF BIT 1 WAS SET THE PREVIOUS TIME AROUND
KEYBIT1   BTFSS   H'37',1     ; LOOK AT PREVIOUS PORTD BIT 1 VALUE
		GOTO    KEYBIT2     ; IF ZERO, NOTHING TO DO BUT CHECK NEXT BIT
; CHECK IF BIT 1 IS SET NOW 
		BTFSC   H'38',1     ; LOOK AT CURRENT PORTD BIT 1 VALUE
		GOTO    KEYBIT2     ; IF ONE, NOTHING TO DO BUT CHECK NEXT BIT
; ONLY GET HERE IF PREVIOUS WAS 1 AND CURRENT IS ZERO I.E. SWITCH
; HAS CLICKED OFF
		BSF     H'39',1     ; SET RESULT FLAG BIT 1
		CALL    TOGLED2     ; TOGGLE LED 2                   
; CHECK IF BIT 2 WAS SET THE PREVIOUS TIME AROUND
KEYBIT2   BTFSS   H'37',2     ; LOOK AT PREVIOUS PORTD BIT 2 VALUE
		GOTO    KEYBIT3     ; IF ZERO, NOTHING TO DO BUT CHECK NEXT BIT
; CHECK IF BIT 2 IS SET NOW 
		BTFSC   H'38',2     ; LOOK AT CURRENT PORTD BIT 2 VALUE
		GOTO    KEYBIT3     ; IF ONE, NOTHING TO DO BUT CHECK NEXT BIT
; ONLY GET HERE IF PREVIOUS WAS 1 AND CURRENT IS ZERO I.E. SWITCH
; HAS CLICKED OFF
		BSF     H'39',2     ; SET RESULT FLAG BIT 2
		CALL    TOGLED2     ; TOGGLE LED 2     
; CHECK IF BIT 3 WAS SET THE PREVIOUS TIME AROUND
KEYBIT3   BTFSS   H'37',3     ; LOOK AT PREVIOUS PORTD BIT 3 VALUE
		GOTO    KEYCURR     ; IF ZERO, NOTHING TO DO BUT CHECK NEXT BIT
; CHECK IF BIT 3 IS SET NOW 
		BTFSC   H'38',3     ; LOOK AT CURRENT PORTD BIT 3 VALUE
		GOTO    KEYCURR     ; IF ONE, NOTHING TO DO BUT CHECK NEXT BIT
; ONLY GET HERE IF PREVIOUS WAS 1 AND CURRENT IS ZERO I.E. SWITCH
; HAS CLICKED OFF
		BSF     H'39',3     ; SET RESULT FLAG BIT 3
		CALL    TOGLED2     ; TOGGLE LED 2     
; MOVE CURRENT TO PREVIOUS VALUE AND RETURN                        
KEYCURR   MOVF    H'38',W     ; LOAD  CURRENT INTO W REG
		MOVWF   H'37'       ; SAVE IT IN PREVIOUS VALUE
		RETURN      
; ROUTINE THAT TOGGLES LED 1 ON AND OFF EACH TIME IT IS CALLED
; USES LOCATION 5B BIT 4 TO KEEP THE CURRENT TOGGLE VALUE
; CAN ALSO BE USED TO SET OR CLEAR LED 1
TOGLED1   BTFSC   H'5B',4     ; TEST TOGGLE, SKIP IF CLEAR       
		GOTO    LED1CLR     ;
		BSF     H'5B',4     ; SET TOGGLE  
LED1SET   BSF     PORTD,4     ; SET ON IN PORTD
		GOTO    TOG1END
LED1CLR   BCF     H'5B',4     ; CLEAR TOGGLE
		BCF     PORTD,4     ; SET OFF IN PORTD 
TOG1END   RETURN         
; ROUTINE THAT TOGGLES LED 2 ON AND OFF EACH TIME IT IS CALLED
; USES LOCATION 5B BIT 5 TO KEEP THE CURRENT TOGGLE VALUE
; CAN ALSO BE USED TO SET OR CLEAR LED 2
TOGLED2   BTFSC   H'5B',5     ; TEST TOGGLE, SKIP IF CLEAR       
		GOTO    LED2CLR     ;
		BSF     H'5B',5     ; SET TOGGLE  
LED2SET   BSF     PORTD,5     ; SET ON IN PORTD
		GOTO    TOG2END
LED2CLR   BCF     H'5B',5     ; CLEAR TOGGLE
		BCF     PORTD,5     ; SET OFF IN PORTD 
TOG2END   RETURN         
; ROUTINE THAT TOGGLES LED 3 ON AND OFF EACH TIME IT IS CALLED
; USES LOCATION 5B BIT 6 TO KEEP THE CURRENT TOGGLE VALUE
; CAN ALSO BE USED TO SET OR CLEAR LED 3
TOGLED3   BTFSC   H'5B',6     ; TEST TOGGLE, SKIP IF CLEAR       
		GOTO    LED3CLR     ;
		BSF     H'5B',6     ; SET TOGGLE  
LED3SET   BSF     PORTD,6     ; SET ON IN PORTD
		GOTO    TOG3END
LED3CLR   BCF     H'5B',6     ; CLEAR TOGGLE
		BCF     PORTD,6     ; SET OFF IN PORTD 
TOG3END   RETURN         
; ROUTINE THAT TOGGLES LED 4 ON AND OFF EACH TIME IT IS CALLED
; USES LOCATION 5B BIT 7 TO KEEP THE CURRENT TOGGLE VALUE
; CAN ALSO BE USED TO SET OR CLEAR LED 4
TOGLED4   BTFSC   H'5B',7     ; TEST TOGGLE, SKIP IF CLEAR       
		GOTO    LED4CLR     ;
		BSF     H'5B',7     ; SET TOGGLE  
LED4SET   BSF     PORTD,7     ; SET ON IN PORTD
		GOTO    TOG4END
LED4CLR   BCF     H'5B',7     ; CLEAR TOGGLE
		BCF     PORTD,7     ; SET OFF IN PORTD 
TOG4END   RETURN         
; ROUTINE THAT DELAYS FOR 1 MILLISECOND (5000 INSTR CYCLES) X VALUE IN LOCN 71H
L57       MOVF    H'71',W     ; LOAD W REG WITH CONTENTS OF DATA LOCN 71H
		IORWF   H'72',W     ; INCLSIVE OR WITH LOCN 72H - SETS Z FLAG IF ZERO
		BTFSC   STATUS,2    ; CHECK Z FLAG IN STATUS AND SKIP IF CLEARED
		RETURN              : RETURN FROM ROUTINE
		MOVLW   H'06'       ; LOAD W REG WITH VALUE 06H
		BCF     PCLATH,3    ; CLEAR PROGRAM PAGE SELECT BIT 3 BEFORE CALL
		BCF     PCLATH,4    ; CLEAR PROGRAM PAGE SELECT BIT 4 BEFORE CALL
		CALL    L70         ; CALL HIGH LEVEL TIMER
		MOVLW   H'CA'       ; LOAD W REG WITH VALUE CAH (202D)
		BCF     PCLATH,3    ; CLEAR PROGRAM PAGE SELECT BIT 3 BEFORE CALL
		BCF     PCLATH,4    ; CLEAR PROGRAM PAGE SELECT BIT 4 BEFORE CALL
		CALL    L6A         ; CALL LOW LEVEL TIMER
		BCF     PCLATH,3    ; CLEAR PROGRAM PAGE SELECT BIT 3 BEFORE CALL
		BCF     PCLATH,4    ; CLEAR PROGRAM PAGE SELECT BIT 4 BEFORE CALL
		DECF    H'71'       ; REDUCE CONTENTS OF DATA LOCN 71H BY ONE
		INCFSZ  H'71',W     ; INCREMENTS LOCN 71H RESULT IN W REG SKIP IF ZERO
		GOTO    L57         ; GO ROUND LOOP AGAIN
		DECF    H'72'       ; REDUCE CONTENTS OF DATA LOCN 72H BY ONE
		GOTO    L57         ; GO ROUND LOOP AGAIN
; LOW LEVEL TIMER ROUTINE - CYCLES ROUND NO OF TIMES SET IN THE VALUE OF W REG
; CAN BE CALLED AT L6A OR L6C
; USES DATA LOCATION 73H AS COUNTER           
L6A       NOP                 ; 
		NOP                 ; 
L6C       MOVWF   H'73'       ; SAVE W REG IN DATA LOCATION 73H
L6D       DECFSZ  H'73'       ; REDUCE VALUE IN LOCN 73H BY 1 AND SKIP IF ZERO
		GOTO    L6D         ; GO ROUND LOOP AGAIN (3 MACHINE CYCLES IN LOOP)
		RETURN              
; HIGH LEVEL TIMER ROUTINE - CYCLES ROUND NO OF TIMES SET IN THE VALUE OF W REG
; CALLS LOW LEVEL TIMER ROUTINE  - USES DATA LOCATION 74H AS COUNTER 
L70       MOVWF   H'74'       ; SAVE W REG IN DATA LOCATION 74H
L71       MOVLW   H'F0'       ; SET W REG TO F0H, VALUE FOR LOW LEVEL TIMER LOOP
		CALL    L6C         ; CALL LOW LEVEL TIMER TO LOOP F0H (240D) TIMES
		DECFSZ  H'74'       ; REDUCE VALUE IN LOCN 74H BY 1 AND SKIP IF ZERO
		GOTO    L71         ; GO ROUND LOOP AGAIN
		RETURN          
; ROUTINE THAT DELAYS FROM 4 MICRO SECS TO 1 MS DEPENDING ON VALUE 
; IN W REG IT CAN TAKE VALUE FROM 00 TO FFH (255D) 
LDELAYE	  NOP
		RETURN	      ; SKIP ROUND DELAY AFTER END OF PULSE 
LDELAY    MOVWF   H'73'       ; SAVE W REG IN DATA LOCATION 73H
		BTFSC	  H'5D',2     ; SKIP DELAY IF REDUCE TIMER LOOP FLAG SET
		GOTO	  LD1E
LD1       NOP                 ; 19 INSTRUCTIONS IN LOOP
		NOP                 ; MEANS THAT 255 TIMES ROUND LOOP = 1MS 
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		DECFSZ  H'73'       ; REDUCE VALUE IN LOCN 73H BY 1 AND SKIP IF ZERO
		GOTO    LD1           
LD1E      RETURN
; ROUTINE THAT DELAYS FROM 4 MICRO SECS TO 1.5 MS DEPENDING ON VALUE 
; IN W REG IT CAN TAKE VALUE FROM 00 TO FFH (255D) 
LDELAY2E  NOP
		RETURN	      ; SKIP ROUND DELAY AFTER END OF PULSE 
LDELAY2   MOVWF   H'73'       ; SAVE W REG IN DATA LOCATION 73H
		BTFSC	  H'5D',2     ; SKIP DELAY IF REDUCE TIMER LOOP FLAG SET
		GOTO	  LD2E
LD2       NOP                 ; 29 INSTRUCTIONS IN LOOP
		NOP                 ; MEANS THAT 255 TIMES ROUND LOOP = 1.5MS 
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		DECFSZ  H'73'       ; REDUCE VALUE IN LOCN 73H BY 1 AND SKIP IF ZERO
		GOTO    LD2           
LD2E     RETURN      
		GOTO     MAIN       ; RETURN TO APP DESIGNER MAIN LOOP
; *** INPUT FILE - C:\PROGRAM FILES\FED\WIZPIC\APPWIZ\MATHS.ASM
		LOCAL NEXT
		NEXT=($+D'130'+32)&0XF800	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 16 BIT MOD & DIVIDE FUNCTIONS
;
MODUSD 		CALL DIVUSD
		BCF PCLATH,3
		BCF PCLATH,4
		GOTO MODD1
MODD		CALL DIVD		; TEMP5/6 IS REMAINDER
		BCF PCLATH,3
		BCF PCLATH,4
MODD1
		MOVF TEMP6,w
		MOVWF ACCH
		MOVF TEMP5,w
		MOVWF ACC
		RETURN
DIVUSD		BCF AFLAGS,7
		CALL PREPMDD2
		GOTO DIVRETD
DIVD         	CALL PREPMDD
DIVRETD         CLRF TEMP5
		CLRF TEMP6
DLOOPD          CLRC
		RLF TEMP3		; TEMP3
		RLF TEMP4		; TEMP4
		RLF TEMP5		; TEMP5
		RLF TEMP6		; TEMP6
		MOVF ACC2H,W
		SUBWF TEMP6,W	; TEMP6
		BCF AFLAGS,0
		BTFSC STATUS,Z
		BSF AFLAGS,0
		BTFSS AFLAGS,0
		GOTO NOCHKD
		MOVF ACC2,w
		SUBWF TEMP5,W	; TEMP5
NOCHKD          BTFSS STATUS,C
		GOTO NOGOD
		MOVF ACC2,w
		SUBWF TEMP5		; TEMP5
		BTFSS STATUS,C
		DECF TEMP6		; TEMP6
		MOVF ACC2H,W
		SUBWF TEMP6		; TEMP6
		BSF STATUS,C
NOGOD           RLF ACC
		RLF ACCH
		DECFSZ TEMP1
		GOTO DLOOPD
		BTFSC AFLAGS,7         ; CHECK SIGN BIT
		GOTO NEGD
		RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 16 BIT MULTIPLICATION FUNCTIONS
;
MULUSD		BCF AFLAGS,7
		CALL PREPMDD2
		GOTO MULD1
MULD            CALL PREPMDD
MULD1		
MULLOOPD        BTFSS ACC2,0
		GOTO NOADDD
		MOVF TEMP3,w
		ADDWF ACC
		SKPNC
		INCF ACCH
		MOVF TEMP4,w
		ADDWF ACCH
NOADDD          CLRC
		RLF TEMP3              ; TEMP 3/4 *= 2
		RLF TEMP4	      ; TEMP4
		RRF ACC2H
		RRF ACC2
		DECFSZ TEMP1
		GOTO MULLOOPD
POSTMDD         BTFSC AFLAGS,7         ; CHECK SIGN BIT
		GOTO NEGD
		RETURN
;
; ROUTINE TO PREPARE ARGUMENTS IN MUL/DIV, CALL WITH SPACE REQUIRED ON STACK
; IN W FINISH WITH FSR POINTING TO COPY OF ACC ON THE STACK
; CALL WITH W HOLDING NUMBER OF BITS 
;
PREPMDD         BCF AFLAGS,7
		MOVF ACCH,w
		XORWF ACC2H,W
		ANDLW H'80'
		IORWF AFLAGS            ; FLAGS BIT 7 HOLDS THE SIGN
		BTFSC ACCH,7
		CALL NEGD
		BCF PCLATH,3
		BCF PCLATH,4
		BTFSC ACC2H,7
		CALL NEG2D
		BCF PCLATH,3
		BCF PCLATH,4
PREPMDD2        MOVLW D'16'
		MOVWF TEMP1
		MOVF ACC,w
		MOVWF TEMP3
		MOVF ACCH,w
		MOVWF TEMP4
		CLRF ACC 
		CLRF ACCH
		RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; VARIOUS UNARY OPERATIONS
;
		LOCAL NEXT
		NEXT=($+32+32)&0XF800	
NEGD		COMF ACC
		COMF ACCH
		GOTO INCD 
NEG2D		COMF ACC2
		COMF ACC2H
		GOTO INC2D 
INCD
		INCFSZ ACC
		RETURN
		INCF ACCH
		RETURN
INC2D
		INCFSZ ACC2
		RETURN
		INCF ACC2H
		RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; UTILITY ROUTINES
;
		LOCAL NEXT
		NEXT=($+10+32)&0XF800	
COPYATOA2
		MOVF ACC,w
		MOVWF ACC2
		MOVF ACCH,w
		MOVWF ACC2H
		RETURN
		LOCAL NEXT
		NEXT=($+10+32)&0XF800	
COPYA2TOA
		MOVF ACC2,w
		MOVWF ACC
		MOVF ACC2H,w
		MOVWF ACCH
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
SWAPAA2
		MOVF ACC,w
		MOVWF TEMP1
		MOVF ACC2,w
		MOVWF ACC
		MOVF TEMP1,w
		MOVWF ACC2
		MOVF ACCH,w
		MOVWF TEMP1
		MOVF ACC2H,w
		MOVWF ACCH
		MOVF TEMP1,w
		MOVWF ACC2H
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
LOADAFROMW	MOVWF FSR
		MOVF 0,w
		MOVWF ACC
		RETURN
LOADDFROMW	MOVWF FSR
		MOVF 0,w
		MOVWF ACC
		INCF FSR
		MOVF 0,w
		MOVWF ACCH
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
LOADA2FROMW	MOVWF FSR
		MOVF 0,w
		MOVWF ACC2
		RETURN
LOADD2FROMW	MOVWF FSR
		MOVF 0,w
		MOVWF ACC2
		INCF FSR
		MOVF 0,w
		MOVWF ACC2H
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
SAVEATOW	MOVWF FSR
		MOVF ACC,w
		MOVWF 0
		RETURN
SAVEDTOW	MOVWF FSR
		MOVF ACC,w
		MOVWF 0
		INCF FSR
		MOVF ACCH,w
		MOVWF 0
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
SAVEA2TOW	MOVWF FSR
		MOVF ACC2,w
		MOVWF 0
		RETURN
SAVED2TOW	MOVWF FSR
		MOVF ACC2,w
		MOVWF 0
		INCF FSR
		MOVF ACC2H,w
		MOVWF 0
		RETURN
		LOCAL NEXT
		NEXT=($+5+32)&0XF800	
TESTA
		MOVF ACC,w
		RETURN
		LOCAL NEXT
		NEXT=($+5+32)&0XF800	
TESTD
		MOVF ACC,w
		IORWF ACCH,W
		RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; VARIOUS STACK OPERATIONS
;
		LOCAL NEXT
		NEXT=($+10+32)&0XF800	
POPA		
		BCF STATUS,IRP
		INCF SP
		MOVF SP,w
		MOVWF FSR
		MOVF 0,w
		MOVWF ACC
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
POPD		
		BCF STATUS,IRP
		INCF SP,W
		INCF SP
		INCF SP
		MOVWF FSR
		MOVF 0,w
		MOVWF ACC
		INCF FSR
		MOVF 0,w
		MOVWF ACCH
		RETURN
		LOCAL NEXT
		NEXT=($+30+32)&0XF800	
PUSHD
		BCF STATUS,IRP
		MOVF SP,w
		MOVWF FSR
		MOVF ACCH,w
		MOVWF 0
		DECF SP
PUSHA		
		BCF STATUS,IRP
		MOVF SP,w
		MOVWF FSR
		MOVF ACC,w
		MOVWF 0
		DECF SP
		RETURN
		LOCAL NEXT
		NEXT=($+10+32)&0XF800	
POP2A		
		BCF STATUS,IRP
		INCF SP
		MOVF SP,w
		MOVWF FSR
		MOVF 0,w
		MOVWF ACC2
		RETURN
		LOCAL NEXT
		NEXT=($+10+32)&0XF800	
POP2D		
		BCF STATUS,IRP
		INCF SP,W
		INCF SP
		INCF SP
		MOVWF FSR
		MOVF 0,w
		MOVWF ACC2
		INCF FSR
		MOVF 0,w
		MOVWF ACC2H
		RETURN
		LOCAL NEXT
		NEXT=($+20+32)&0XF800	
PUSH2D		
		BCF STATUS,IRP
		MOVF SP,w
		MOVWF FSR
		MOVF ACC2H,w
		MOVWF 0
		DECF SP
PUSH2A		
		BCF STATUS,IRP
		MOVF SP,w
		MOVWF FSR
		MOVF ACC2,w
		MOVWF 0
		DECF SP
		RETURN
		LOCAL NEXT
		NEXT=($+D'1024'+32)&0XF800	
		ORG NEXT
; ROUTINE TO SET UP SERVO POSITION LISTS FOR WALKING FOR EACH LEG
SETWALK1  NOP                    
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST               
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST                    
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST   
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0      
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST           
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C0'       ; SAVE IT IN LIST            
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST             
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST              
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C4'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C5'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C6'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C7'       ; SAVE IT IN LIST         
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0         
; 2ND LEG SERVO LISTS FOR SETWALK
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST     
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST                    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST             
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0            
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST                    
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST        
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0
; 3RD LEG SERVO LISTS FOR SETWALK
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST               
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST                    
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST   
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3 
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'B8'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST           
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C0'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST             
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST              
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C4'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C5'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C6'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C7'       ; SAVE IT IN LIST         
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0         
; 4TH LEG SERVO LISTS FOR SETWALK
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST     
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST                    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST             
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST               
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST                    
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST   
		MOVLW   H'38'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST             
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST        
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0
; SET UP THE INITIAL VALUES IN THE CURRENT SERVO VALUE FIELDS
; THIS IS AN ENTRY POINT THAT CAN ALSO BE CALLED
FIRSTVALS BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1   
		MOVF    H'A0',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'49'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1    
		MOVF    H'B4',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'4B'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION   
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1      
		MOVF    H'C8',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'3B'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		MOVF    H'DC',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'3D'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3
		MOVF    H'A0',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'41'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3   
		MOVF    H'B4',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'43'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION   
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3    
		MOVF    H'C8',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'45'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3
		MOVF    H'DC',W     ; GET FIRST SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'47'       ; SAVE IT IN CURRENT SERVO VALUE LOCATION  
; SET UP NEXTVALS
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1   
		MOVF    H'A1',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'50'       ; SAVE IT IN NEXT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1    
		MOVF    H'B5',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'51'       ; SAVE IT IN NEXT SERVO VALUE LOCATION   
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1      
		MOVF    H'C9',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'52'       ; SAVE IT IN NEXT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		MOVF    H'DD',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
		MOVWF   H'53'       ; SAVE IT IN NEXT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3
		MOVF    H'A1',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'54'       ; SAVE IT IN NEXT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3   
		MOVF    H'B5',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'55'       ; SAVE IT IN NEXT SERVO VALUE LOCATION   
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3    
		MOVF    H'C9',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'56'       ; SAVE IT IN NEXT SERVO VALUE LOCATION  
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1 
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3
		MOVF    H'DD',W     ; GET SECOND SERVO LOCATION
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		MOVWF   H'57'       ; SAVE IT IN NEXT SERVO VALUE LOCATION 
		GOTO	  RETCODE     ; RETURN FROM SETWALK1
; ROUTINE TO SET UP READY TO WALK VALUES FOR EACH SERVO
READY1	  BSF     STATUS,RP0  ; SET STATUS REG BIT 5  - SELECT DATA BANK 1
; SET UP 1ST LOWER LEG VALUES
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
; SET UP 1ST UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
; SET UP 2ND LOWER LEG VALUES 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
; SET UP 2ND UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
; SET UP 3RD LOWER LEG VALUES
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5  AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6  - SELECT DATA BANK 3
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
; SET UP 3RD UPPER LEG VALUES
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
; SET UP 4TH LOWER LEG VALUES 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
; SET UP 4TH UPPER LEG VALUES
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  AND 
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		GOTO	  RETCODE     ; RETURN FROM READY TO COMPETE ROUTINE
; ROUTINE TO SET UP READY TO FAST TROT VALUES FOR EACH SERVO
READY2	  BSF     STATUS,RP0  ; SET STATUS REG BIT 5  - SELECT DATA BANK 1
; SET UP 1ST LOWER LEG VALUES
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
; SET UP 1ST UPPER LEG VALUES
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
; SET UP 2ND LOWER LEG VALUES 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
; SET UP 2ND UPPER LEG VALUES
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0
; SET UP 3RD LOWER LEG VALUES
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5  AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6  - SELECT DATA BANK 3
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
; SET UP 3RD UPPER LEG VALUES
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
; SET UP 4TH LOWER LEG VALUES 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
; SET UP 4TH UPPER LEG VALUES
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  AND 
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		GOTO	  RETCODE     ; RETURN FROM READY TO COMPETE ROUTINE          
STNDSTILL BSF     STATUS,RP0  ; SET STATUS REG BIT 5  - SELECT DATA BANK 1
; SET UP 1ST LOWER LEG VALUES
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
; SET UP 1ST UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST                 
; SET UP 2ND LOWER LEG VALUES 
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
; SET UP 2ND UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0 
; SET UP 3RD LOWER LEG VALUES
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5  AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6  - SELECT DATA BANK 3
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
; SET UP 3RD UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST                 
; SET UP 4TH LOWER LEG VALUES 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST  
; SET UP 4TH UPPER LEG VALUES
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD END OF LIST MARKER INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  AND 
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		GOTO	  RETCODE     ; RETURN FROM STAND STILL ROUTINE
SLOWTROT  BSF     STATUS,RP0  ; SET STATUS REG BIT 5  - SELECT DATA BANK 1
; SET UP 1ST LOWER LEG VALUES FOR SLOW TROT
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST               
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST                    
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST   
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST             
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST              
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
; SET UP 1ST UPPER LEG VALUES FOR SLOW TROT
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST           
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C0'       ; SAVE IT IN LIST            
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST             
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST              
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST               
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C4'       ; SAVE IT IN LIST                 
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C5'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C6'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C7'       ; SAVE IT IN LIST         
; SET UP 2ND LOWER LEG VALUES FOR SLOW TROT 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST 
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST    
; SET UP 2ND UPPER LEG VALUES FOR SLOW TROT
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                         
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST   
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST  
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST                         
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST  
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST            
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST                         
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST 
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST                         
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST 
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0 
; SET UP 3RD LOWER LEG VALUES FOR SLOW TROT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5  AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6  - SELECT DATA BANK 3
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST          
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST          
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST 
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST          
		MOVLW   H'FE'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'FE'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
; SET UP 3RD UPPER LEG VALUES FOR SLOW TROT
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'98'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST        
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'B7'       ; SAVE IT IN LIST      
		MOVLW   H'48'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST   
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST                 
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST        
		MOVLW   H'72'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'BB'       ; SAVE IT IN LIST      
		MOVLW   H'74'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'BC'       ; SAVE IT IN LIST     
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST   
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST                 
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST        
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'C0'       ; SAVE IT IN LIST      
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST   
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST                 
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST        
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'C4'       ; SAVE IT IN LIST      
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'C5'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'C6'       ; SAVE IT IN LIST      
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'C7'       ; SAVE IT IN LIST                      
; SET UP 4TH LOWER LEG VALUES FOR SLOW TROT
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST    
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST 
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST           
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST 
; SET UP 4TH UPPER LEG VALUES FOR SLOW TROT
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                         
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST  
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST   
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST                         
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST  
		MOVLW   H'58'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST  
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST  
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST  
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST  
		MOVLW   H'77'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST  
		MOVLW   H'77'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST  
		MOVLW   H'76'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST  
		MOVLW   H'76'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST 
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  AND 
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		GOTO 	  RETCODE     ; RETURN FROM SLOW TROT ROUTINE
RETCODE	  CLRF	  STATUS
		CLRF 	  PCLATH
		RETURN 		; RETURN FROM ROUTINES TO BASE PAGE
FASTTROT  BSF     STATUS,RP0  ; SET STATUS REG BIT 5  - SELECT DATA BANK 1
; SET UP 1ST LOWER LEG VALUES FOR FAST TROT
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
; SET UP 1ST UPPER LEG VALUES FOR FAST TROT
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'88'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
; SET UP 2ND LOWER LEG VALUES FOR FAST TROT 
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST 
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST    
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST          
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST 
		MOVLW   H'D0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
; SET UP 2ND UPPER LEG VALUES FOR FAST TROT
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                         
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST   
		MOVLW   H'88'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST  
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST                         
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST  
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST  
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST            
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST   
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  - SELECT DATA BANK 0 
; SET UP 3RD LOWER LEG VALUES FOR FAST TROT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5  AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6  - SELECT DATA BANK 3
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST          
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST          
		MOVLW   H'FE'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST 
		MOVLW   H'FE'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST          
; SET UP 3RD UPPER LEG VALUES FOR FAST TROT
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST        
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'B7'       ; SAVE IT IN LIST      
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST   
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST                 
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST        
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'BB'       ; SAVE IT IN LIST      
		MOVLW   H'98'       ; LOAD LITERAL INTO W REG          
		MOVWF   H'BC'       ; SAVE IT IN LIST     
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST                 
; SET UP 4TH LOWER LEG VALUES FOR FAST TROT
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST    
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST          
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST          
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST 
; SET UP 4TH UPPER LEG VALUES FOR FAST TROT
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST  
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                         
		MOVLW   H'68'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST  
		MOVLW   H'58'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST   
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST  
		MOVLW   H'58'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST                         
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST  
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5  AND 
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6  - SELECT DATA BANK 0
		GOTO 	  RETCODE     ; RETURN FROM FAST TROT ROUTINE
; 		LEG SETTINGS TO TURN LEFT
;		TAKES SHORT STEPS ON LEGS 1 AND 3
TURNLEFT  NOP
		NOP                    
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST               
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST                    
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST   
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0      
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST           
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C0'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST             
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST              
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C4'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C5'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C6'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C7'       ; SAVE IT IN LIST         
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0   
; 2ND LEG SERVO LISTS FOR TURN LEFT
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST     
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST                    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST             
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0            
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST                    
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST        
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0
; 3RD LEG SERVO LISTS FOR TURN LEFT
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AB'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AC'       ; SAVE IT IN LIST               
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AD'       ; SAVE IT IN LIST                    
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AE'       ; SAVE IT IN LIST   
		MOVLW   H'FA'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AF'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B0'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B1'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B2'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B3'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'B8'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BF'       ; SAVE IT IN LIST           
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C0'       ; SAVE IT IN LIST            
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C1'       ; SAVE IT IN LIST             
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C2'       ; SAVE IT IN LIST              
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C3'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C4'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C5'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C6'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C7'       ; SAVE IT IN LIST         
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0         
; 4TH LEG SERVO LISTS FOR TURN LEFT
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D3'       ; SAVE IT IN LIST     
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D4'       ; SAVE IT IN LIST          
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D5'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D6'       ; SAVE IT IN LIST                    
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D7'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D8'       ; SAVE IT IN LIST             
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D9'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DA'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DB'       ; SAVE IT IN LIST             
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E7'       ; SAVE IT IN LIST               
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E8'       ; SAVE IT IN LIST                    
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E9'       ; SAVE IT IN LIST   
		MOVLW   H'38'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EA'       ; SAVE IT IN LIST             
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EB'       ; SAVE IT IN LIST              
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EC'       ; SAVE IT IN LIST               
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'ED'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EE'       ; SAVE IT IN LIST        
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'EF'       ; SAVE IT IN LIST  
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0
		GOTO	  RETCODE     ; RETURN FROM TURNLEFT
;         PREVIOUS TURNLEFT   
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST                 
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0    
;	  TURNLEFT SETTINGS	  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0         
; 2ND LEG SERVO LISTS FOR TURNLEFT	
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG         
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0            
;	  TURNLEFT SETTINGS		  
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'6C'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0
; 3RD LEG SERVO LISTS FOR TURNLEFT 	
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;	  TURNLEFT SETTINGS		  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3 
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0         
; 4TH LEG SERVO LISTS FOR TURNLEFT 	
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'06'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;	  TURNLEFT SETTINGS		  
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0
		GOTO	  RETCODE     ; RETURN FROM TURNLEFT
;		LEG SETTINGS TO TURN RIGHT
;		TAKES SHORT STEPS ON LEGS 2 AND 4
TURNRIGHT NOP                   
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0    
;	  TURN RIGHT SETTINGS	  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 1ST LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'50'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0    
; 2ND LEG SERVO LISTS FOR TURN RIGHT  
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0 
;	  TURN RIGHT SETTINGS	  	  
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 2ND LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 - SELECT DATA BANK 1  
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'A0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'90'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'81'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'79'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 - SELECT DATA BANK 0
; 3RD LEG SERVO LISTS FOR TURN RIGHT 	  
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1A0H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS,RP0  ; SET STATUS REG BIT 5 AND
		BSF     STATUS,RP1  ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A0'       ; SAVE IT IN LIST
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A1'       ; SAVE IT IN LIST          
		MOVLW   H'20'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A2'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A3'       ; SAVE IT IN LIST           
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A4'       ; SAVE IT IN LIST            
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A5'       ; SAVE IT IN LIST             
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A6'       ; SAVE IT IN LIST              
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A7'       ; SAVE IT IN LIST               
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A8'       ; SAVE IT IN LIST                 
		MOVLW   H'FD'       ; LOAD LITERAL INTO W REG
		MOVWF   H'A9'       ; SAVE IT IN LIST
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'AA'       ; SAVE IT IN LIST     
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;	  TURN RIGHT SETTINGS	  	  
;         CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 3RD LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1B4H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3 
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B4'       ; SAVE IT IN LIST   
		MOVLW   H'98'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B5'       ; SAVE IT IN LIST                 
		MOVLW   H'B0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B6'       ; SAVE IT IN LIST
		MOVLW   H'C0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B7'       ; SAVE IT IN LIST     
		MOVLW   H'48'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B8'       ; SAVE IT IN LIST          
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'B9'       ; SAVE IT IN LIST               
		MOVLW   H'70'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BA'       ; SAVE IT IN LIST                    
		MOVLW   H'74'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BB'       ; SAVE IT IN LIST   
		MOVLW   H'74'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BC'       ; SAVE IT IN LIST
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BD'       ; SAVE IT IN LIST          
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'BE'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0         
; 4TH LEG SERVO LISTS FOR TURN RIGHT
; CODE TO SET UP TABLE OF LOWER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1C8H ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C8'       ; SAVE IT IN LIST
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'C9'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CA'       ; SAVE IT IN LIST          
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CB'       ; SAVE IT IN LIST           
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CC'       ; SAVE IT IN LIST           
		MOVLW   H'01'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CD'       ; SAVE IT IN LIST            
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CE'       ; SAVE IT IN LIST             
		MOVLW   H'FF'       ; LOAD LITERAL INTO W REG
		MOVWF   H'CF'       ; SAVE IT IN LIST              
		MOVLW   H'E0'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D0'       ; SAVE IT IN LIST               
		MOVLW   H'80'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D1'       ; SAVE IT IN LIST                 
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'D2'       ; SAVE IT IN LIST
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0  
;	  TURN RIGHT SETTINGS	    
; CODE TO SET UP TABLE OF UPPER LEG SERVO VALUES FOR 4TH LEG
;         SET UP INITIAL DATA VALUES IN LIST FROM LOCATION 1DCH ENDED BY 00
;         VALUE ARE 01 = FULL LEFT, 80 = CENTRE TO FF = FULL RIGHT
		BSF     STATUS, RP0 ; SET STATUS REG BIT 5 AND
		BSF     STATUS, RP1 ; SET STATUS REG BIT 6 - SELECT DATA BANK 3  
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DC'       ; SAVE IT IN LIST
		MOVLW   H'78'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DD'       ; SAVE IT IN LIST          
		MOVLW   H'77'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DE'       ; SAVE IT IN LIST                    
		MOVLW   H'76'       ; LOAD LITERAL INTO W REG
		MOVWF   H'DF'       ; SAVE IT IN LIST            
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E0'       ; SAVE IT IN LIST             
		MOVLW   H'75'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E1'       ; SAVE IT IN LIST              
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E2'       ; SAVE IT IN LIST               
		MOVLW   H'30'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E3'       ; SAVE IT IN LIST                 
		MOVLW   H'40'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E4'       ; SAVE IT IN LIST
		MOVLW   H'60'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E5'       ; SAVE IT IN LIST     
		MOVLW   H'00'       ; LOAD LITERAL INTO W REG
		MOVWF   H'E6'       ; SAVE IT IN LIST          
		BCF     STATUS,RP0  ; CLEAR STATUS REG BIT 5 AND      
		BCF     STATUS,RP1  ; CLEAR STATUS REG BIT 6 - SELECT DATA BANK 0   
		GOTO	  RETCODE     ; RETURN FROM TURNRIGHT
; KEY VARIABLES USED
; HEX  PURPOSE
;
;CBLOCK VARIABLES USED BY LIBRARY ROUTINES - DO NOT USE THESE LOCATIONS !!!
; 20H A0H 120H 1A0H W_TEMP - W_TEMP3
; 24H TO 2FH TEMP1 TO TEMP12
; 30H SP
; 31H TO 34H ACC1 AND ACC2
; 35H AFLAGS
; END OF CBLOCK VARIABLES
; 36 	NOT USED
; 37    PREVIOUS PORT D VALUE USED IN KEYTEST ROUTINE
; 38    CURRENT PORT D VALUE USED IN KEYTEST ROUTINE
; 39    RETURNED VALUE FROM KEYTEST ROUTINE - LOWER 4 BITS SET FOR KEYS ACTIVE
; 3A    2ND LOWER LEG POINTER TO CURRENT SERVO LIST ITEM
; 3B    2ND LOWER LEG CURRENT SERVO VALUE GETS REFRESHED ON EACH SERVO CYCLE
; 3C    2ND UPPER LEG POINTER TO CURRENT SERVO LIST ITEM
; 3D    2ND UPPER LEG CURRENT SERVO VALUE
; 40    3RD LOWER LEG POINTER TO CURRENT SERVO LIST ITEM
; 41    3RD LOWER LEG CURRENT SERVO VALUE
; 42    3RD UPPER LEG POINTER TO CURRENT SERVO LIST ITEM
; 43    3RD UPPER LEG CURRENT SERVO VALUE
; 44    4TH LOWER LEG POINTER TO CURRENT SERVO LIST ITEM
; 45    4TH LOWER LEG CURRENT SERVO VALUE
; 46    4TH UPPER LEG POINTER TO CURRENT SERVO LIST ITEM
; 47    4TH UPPER LEG CURRENT SERVO VALUE
; 48    1ST LOWER LEG POINTER TO CURRENT SERVO LIST ITEM
; 49    1ST LOWER LEG CURRENT SERVO VALUE
; 4A    1ST UPPER LEG POINTER TO CURRENT SERVO LIST ITEM
; 4B    1ST UPPER LEG CURRENT SERVO VALUE
; 50    1ST LOWER LEG NEXT SERVO VALUE
; 51    1ST UPPER LEG NEXT SERVO VALUE
; 52    2ND LOWER LEG NEXT SERVO VALUE
; 53    2ND UPPER LEG NEXT SERVO VALUE
; 54    3RD LOWER LEG NEXT SERVO VALUE
; 55    3RD UPPER LEG NEXT SERVO VALUE
; 56    4TH LOWER LEG NEXT SERVO VALUE
; 57    4TH UPPER LEG NEXT SERVO VALUE
; 58	VALUE THAT IS HELD IN PORTD FOR THE LEDS AND 4 INPUT KEYS
; 59    LED TOGGLE SPEED COUNTER
; 5A    NOT USED CURRENTLY
; 5B    LED 2 TOGGLE
; 5C    WORKING FIELD USED WHEN CALCULATING REMAINING TIME AFTER SERVO ACTIVATED
; 5D    SPECIAL CONTROL FLAGS:- DO ACTION WHEN SET
; BIT 0 - RUN SINGLE STEP, MOVING ON ONLY WHEN KEY IS PRESSED
; BIT 1 - SWITCH OFF INTERPOLATE
; BIT 2 - SIMULATE MODE REDUCE TIMER LOOPS TO MIN 
; BIT 3 - SIMULATE MODE SKIP KEY TESTS
; BIT 4 - EXPAND UPPER SERVO MOVEMENT RANGE
; BIT 5 - EXPAND LOWER SERVO MOVEMENT RANGE
; BIT 6 - NOT USED SO FAR
; BIT 7 - GO TO SPECIAL ROUTINES AT START OF MAIN LOOP 
;
; 5E	SPEED INITIAL VALUE - I.E. HOW MANY SERVO DRIVE CYCLES BEFORE IT GETS 
;	THE NEXT VALUE FROM THE TABLE
; 5F 	CURRENT VALUE OF SPEED COUNTER. IT COUNTS DOWN FROM INITIAL VALUE AND 
;   	GETS THE NEXT VALUE WHEN COUNTER GETS TO ZERO
; 60	CS 8 BIT CURRENT SERVO VALUE		 
; 61	NS 8 BIT NEXT SERVO VALUE
; 62	ISC   (SV-SC) 8 BIT INVERSE OF SPEED COUNTER
; 63	SDIFF (NS-CS) 8 BIT DIFFERENCE 
; 64	DSIGN IS 1 IF NS-CS IS NEGATIVE
; 65	NEGD1 SET TO 1 IF SDIFF WOULD BE NEGATIVE
; 66	IV 8 BIT CALCULATED INCREMENTAL VALUE RESULT
; 67	FV 8 BIT FINAL VALUE TO USE  
; 68    TEMP FIELD USED IN NEXTSVALN
; 69    TEMP FIELD USED IN NEXTSVALN
; 6A    VALUE THAT IS HELD IN PORTB - FOR THE SERVOS
; 6B    SN SERVO NUMBER BEING PROCESSED
; 6C & 6D TEMP STORAGE FOR 16 BIT ACC FOR INTERP ROUTINE
; 6E	DIRECTION VALUE 16 = STRAIGHT LESS = LEFT, MORE = RIGHT
; 6F    CURRENT PROGRAM BEING RUN
; SERVO LISTS
; 1ST LEG
; SERVO 1 A0-B3 THE LOWER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; SERVO 2 B4-C7 THE UPPER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; 2ND LEG
; SERVO 3 C8-DB THE LOWER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; SERVO 4 DC-EF THE UPPER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; 3RD LEG
; SERVO 5 1A0-1B3 THE LOWER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; SERVO 6 1B4-1C7 THE UPPER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; 4TH LEG
; SERVO 7 1C8-1DB THE LOWER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; SERVO 8 1DC-1EF THE UPPER LEG SERVO VALUES LIST ENDING WITH AN ENTRY WITH VALUE 00
; KEY SEQUENCES
; ROBOT KEY SEQUENCES
; KEYS  4  2  1
;          3
;       
;          3
;        1 2 4
;
; AT START UP 
; 1 LOAD STANDSTILL, TOGGLE LED1
;    SET SPEED TO SLOW, RUN MAINPROG
; 2 LOAD SETWALK1, TOGGLE LED2
; 	ANY KEY RUN MAINPROG
; 3 LOAD CALIBRATE, TOGGLE LED3
; 	3 SET SINGLE STEP
; 	1, 2 OR 4 SET AUTO RUN
; 		3 NO INTERPOLATE
; 		1, 2 OR 4 INTERPOLATE
; 			1 EXPANDED RANGE BOTH 
; 			2 EXPANDED RANGE AT HIP
; 			3 EXPANDED RANGE AT KNEE
; 			4 NO EXPANDED RANGE
; 4 LOAD WALKSLOW, TOGGLE LED4
; IN MAIN LOOP
; 	1 TURN RIGHT
; 	2 SPEED UP
; 	3 SLOW DOWN
; 	4 TURN LEFT
; 

END
